/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.items;

import com.devmaster.dangerzone.misc.DangerZone;
import com.devmaster.dangerzone.util.ModdedTier;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class Sword
extends SwordItem {
    public int durabilityMultiplier;
    protected static final UUID MOVESPEED = UUID.fromString("35f5b798-7778-4017-98f9-ff557dc28f03");
    protected static final UUID REACH = UUID.fromString("168fad76-3979-4638-91c9-a366c0933551");
    protected String name;
    private String[] info = new String[0];
    protected float reach = 0.0f;
    protected float movespeed = 0.0f;
    protected float attackspeed = 0.0f;
    protected Multimap<Attribute, AttributeModifier> modifiers;
    protected ItemStack repairitem;
    protected Map<Enchantment, Integer> defaultEnchantments = new HashMap<Enchantment, Integer>();
    private static final String HAS_ENCHANTS_TAG = "hasEnchants";

    public Sword(ModdedTier tier, int durabilityMultiplier) {
        super((IItemTier)tier, -1, -2.4f, new Item.Properties().func_200916_a(DangerZone.WEAPONS));
        this.repairitem = tier.getRepairItem();
        this.durabilityMultiplier = durabilityMultiplier;
    }

    public Sword build(float reach, float movespeed) {
        this.reach = reach;
        this.movespeed = movespeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Sword modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Sword modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.modifiers = builder.build();
        return this;
    }

    public Sword rebuild() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.modifiers);
        if (this.movespeed != 0.0f) {
            builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(MOVESPEED, "Sword modifier", (double)this.movespeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.reach != 0.0f) {
            builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(REACH, "Sword modifier", (double)this.reach, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        this.modifiers = builder.build();
        return this;
    }

    public Sword addDefaultEnchantment(Enchantment enchantment, int level) {
        this.defaultEnchantments.put(enchantment, level);
        return this;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.applyDefaultEnchantments(stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof LivingEntity) {
            this.applyDefaultEnchantments(stack);
        }
    }

    private void applyDefaultEnchantments(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n(HAS_ENCHANTS_TAG)) {
            return;
        }
        for (Map.Entry<Enchantment, Integer> entry : this.defaultEnchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            int level = entry.getValue();
            stack.func_77966_a(enchantment, level);
        }
        stack.func_196082_o().func_74757_a(HAS_ENCHANTS_TAG, true);
    }

    public Sword rebuildWith(Attribute attribute, UUID id, String modifiername, double value, AttributeModifier.Operation valuetype) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.modifiers);
        builder.put((Object)attribute, (Object)new AttributeModifier(id, modifiername, value, valuetype));
        this.modifiers = builder.build();
        return this;
    }

    public Sword addInfo(String ... newInfo) {
        if (newInfo != null && newInfo.length > 0) {
            String[] combinedInfo = new String[this.info.length + newInfo.length];
            System.arraycopy(this.info, 0, combinedInfo, 0, this.info.length);
            System.arraycopy(newInfo, 0, combinedInfo, this.info.length, newInfo.length);
            this.info = combinedInfo;
        }
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        for (String s : this.info) {
            list.add((ITextComponent)new StringTextComponent(s));
        }
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.modifiers;
        }
        return super.func_111205_h(slot);
    }
}

