/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.items;

import com.devmaster.dangerzone.misc.DangerZone;
import com.devmaster.dangerzone.util.RegistryHandler;
import com.devmaster.dangerzone.world.teleportors.CrystalTeleporter;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;

public class TermiteToken
extends Item {
    public TermiteToken() {
        super(new Item.Properties().func_200916_a(DangerZone.TAB));
    }

    private boolean isInventoryEmpty(PlayerEntity player) {
        ITag.INamedTag<Item> allowedItemsTag = DangerZone.CRYSTAL_DIMENSION_ALLOWED_ITEMS;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || allowedItemsTag.func_230235_a_((Object)stack.func_77973_b())) continue;
            return false;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b() || allowedItemsTag.func_230235_a_((Object)stack.func_77973_b())) continue;
            return false;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_190926_b() || allowedItemsTag.func_230235_a_((Object)stack.func_77973_b())) continue;
            return false;
        }
        if (ModList.get().isLoaded("curios")) {
            return this.checkCuriosSlots(player, (ITag<Item>)allowedItemsTag);
        }
        return true;
    }

    private boolean checkCuriosSlots(PlayerEntity player, ITag<Item> allowedItemsTag) {
        return CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b() || allowedItemsTag.func_230235_a_((Object)stack.func_77973_b())) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (world.func_234923_W_() == RegistryHandler.CRYSTAL) {
                if (!ForgeHooks.onTravelToDimension((Entity)serverPlayer, (RegistryKey)World.field_234918_g_)) {
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                stack.func_190918_g(1);
                this.teleportToDimension(world, (PlayerEntity)serverPlayer, (RegistryKey<World>)World.field_234918_g_);
            } else {
                if (!this.isInventoryEmpty((PlayerEntity)serverPlayer)) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Your inventory must be clear as a crystal to enter"), player.func_110124_au());
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                if (!ForgeHooks.onTravelToDimension((Entity)serverPlayer, RegistryHandler.CRYSTAL)) {
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                stack.func_190918_g(1);
                this.teleportToDimension(world, (PlayerEntity)serverPlayer, RegistryHandler.CRYSTAL);
            }
            serverPlayer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void teleportToDimension(World worldIn, PlayerEntity player, RegistryKey<World> dimension) {
        if (player.func_70089_S() && !worldIn.func_201670_d() && !player.func_184218_aH() && player.func_184222_aU()) {
            ServerWorld destinationWorld;
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            MinecraftServer server = player.func_184102_h();
            ServerWorld serverWorld = destinationWorld = server != null ? server.func_71218_a(dimension) : null;
            if (destinationWorld == null) {
                return;
            }
            CrystalTeleporter teleporter = new CrystalTeleporter();
            playerMP.changeDimension(destinationWorld, (ITeleporter)teleporter);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("\u00a77This is needed to get to the Crystal Dimension\u00a77"));
    }
}

