/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class ArmourEvents {
    private EventType type;
    private float eventmodifier;
    private QuadConsumer<PlayerEntity, Entity, DamageSource, ItemStack> action;
    private QuadPredicate<PlayerEntity, Entity, DamageSource, ItemStack> condition;
    public static HashMap<EventType, ArrayList<ArmourEvents>> eventlist = new HashMap();

    public ArmourEvents(EventType type, QuadPredicate<PlayerEntity, Entity, DamageSource, ItemStack> condition, QuadConsumer<PlayerEntity, Entity, DamageSource, ItemStack> action) {
        this.type = type;
        this.condition = condition != null ? condition : (player, enemy, source, helditem) -> true;
        this.action = action;
        this.eventmodifier = 1.0f;
    }

    public static void addEvent(ArmourEvents event) {
        eventlist.computeIfAbsent(event.getEventType(), k -> new ArrayList()).add(event);
    }

    public EventType getEventType() {
        return this.type;
    }

    public float getModifier() {
        return this.eventmodifier;
    }

    public QuadPredicate<PlayerEntity, Entity, DamageSource, ItemStack> getCondition() {
        return this.condition;
    }

    public QuadConsumer<PlayerEntity, Entity, DamageSource, ItemStack> getAction() {
        return this.action;
    }

    private void doEvents(EventType type, Event event, PlayerEntity player, LivingEntity target) {
        if (eventlist.containsKey((Object)type)) {
            ItemStack stack = player.func_184614_ca();
            for (ArmourEvents e : eventlist.get((Object)type)) {
                LivingHurtEvent ev;
                if (event instanceof LivingHurtEvent) {
                    ev = (LivingHurtEvent)event;
                    if (!e.getCondition().test(player, (Entity)target, ev.getSource(), stack)) continue;
                    ev.setAmount(ev.getAmount() * e.getModifier());
                    e.getAction().accept(player, (Entity)target, ev.getSource(), stack);
                    continue;
                }
                if (event instanceof LivingDamageEvent) {
                    ev = (LivingDamageEvent)event;
                    if (!e.getCondition().test(player, (Entity)target, ev.getSource(), stack)) continue;
                    ev.setAmount(ev.getAmount() * e.getModifier());
                    e.getAction().accept(player, (Entity)target, ev.getSource(), stack);
                    continue;
                }
                if (event instanceof LivingFallEvent) {
                    ev = (LivingFallEvent)event;
                    if (!e.getCondition().test(player, null, null, stack)) continue;
                    ev.setDistance(ev.getDistance() * e.getModifier());
                    e.getAction().accept(player, null, null, stack);
                    continue;
                }
                if (event instanceof LivingEvent.LivingJumpEvent) {
                    if (!e.getCondition().test(player, null, null, stack)) continue;
                    player.func_213293_j(player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b * (double)e.getModifier(), player.func_213322_ci().field_72449_c);
                    e.getAction().accept(player, null, null, stack);
                    continue;
                }
                if (!(event instanceof LivingEvent.LivingUpdateEvent) || !e.getCondition().test(player, null, null, stack)) continue;
                e.getAction().accept(player, null, null, stack);
            }
        }
    }

    @FunctionalInterface
    public static interface QuadPredicate<T, U, V, W> {
        public boolean test(T var1, U var2, V var3, W var4);

        default public QuadPredicate<T, U, V, W> and(QuadPredicate<? super T, ? super U, ? super V, ? super W> other) {
            Objects.requireNonNull(other);
            return (t, u, v, w) -> this.test(t, u, v, w) && other.test(t, u, v, w);
        }

        default public QuadPredicate<T, U, V, W> negate() {
            return (t, u, v, w) -> !this.test(t, u, v, w);
        }

        default public QuadPredicate<T, U, V, W> or(QuadPredicate<? super T, ? super U, ? super V, ? super W> other) {
            Objects.requireNonNull(other);
            return (t, u, v, w) -> this.test(t, u, v, w) || other.test(t, u, v, w);
        }
    }

    @FunctionalInterface
    public static interface QuadConsumer<K, V, S, T> {
        public void accept(K var1, V var2, S var3, T var4);
    }

    public static enum EventType {
        Auto,
        PlayerFell,
        PlayerJumped,
        PlayerHurtByProjectile,
        PlayerHurtByMelee,
        PlayerHurtByMagic,
        PlayerCausedProjectileDamage,
        PlayerCausedMeleeDamage,
        PlayerCausedMagicDamage,
        CritChance;

    }
}

