/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.misc;

import com.devmaster.dangerzone.items.Armour;
import com.devmaster.dangerzone.items.Axe;
import com.devmaster.dangerzone.items.Hoe;
import com.devmaster.dangerzone.items.Pickaxe;
import com.devmaster.dangerzone.items.Shovel;
import com.devmaster.dangerzone.items.Sword;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HitCostEvent {
    public HitCostEvent() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            this.applyPickaxeHitCost(livingAttacker);
            this.applyAxeHitCost(livingAttacker);
            this.applySwordHitCost(livingAttacker);
            this.applyShovelHitCost(livingAttacker);
            this.applyHoeHitCost(livingAttacker);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof LivingEntity) {
            LivingEntity entity = event.getEntityLiving();
            this.applyArmorHitCost(entity);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof PlayerEntity) {
            this.applyPickaxeHitCost((LivingEntity)player);
            this.applyAxeHitCost((LivingEntity)player);
            this.applySwordHitCost((LivingEntity)player);
            this.applyShovelHitCost((LivingEntity)player);
            this.applyHoeHitCost((LivingEntity)player);
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof PlayerEntity) {
            this.applyHoeHitCost((LivingEntity)player);
        }
    }

    private void applyArmorHitCost(LivingEntity entity) {
        for (ItemStack armorPiece : entity.func_184193_aE()) {
            if (!(armorPiece.func_77973_b() instanceof Armour)) continue;
            Armour armour = (Armour)armorPiece.func_77973_b();
            int damage = armour.durabilityMultiplier;
            armorPiece.func_222118_a(damage, entity, e -> e.func_213361_c(armorPiece.getEquipmentSlot()));
        }
    }

    private void applySwordHitCost(LivingEntity attacker) {
        ItemStack mainHandItem = attacker.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof Sword) {
            Sword sword = (Sword)mainHandItem.func_77973_b();
            int damage = sword.durabilityMultiplier;
            mainHandItem.func_222118_a(damage, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
    }

    private void applyPickaxeHitCost(LivingEntity attacker) {
        ItemStack mainHandItem = attacker.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof Pickaxe) {
            Pickaxe pickaxe = (Pickaxe)mainHandItem.func_77973_b();
            int damage = pickaxe.durabilityMultiplier;
            mainHandItem.func_222118_a(damage, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
    }

    private void applyAxeHitCost(LivingEntity attacker) {
        ItemStack mainHandItem = attacker.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof Axe) {
            Axe axe = (Axe)mainHandItem.func_77973_b();
            int damage = axe.durabilityMultiplier;
            mainHandItem.func_222118_a(damage, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
    }

    private void applyShovelHitCost(LivingEntity attacker) {
        ItemStack mainHandItem = attacker.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof Shovel) {
            Shovel shovel = (Shovel)mainHandItem.func_77973_b();
            int damage = shovel.durabilityMultiplier;
            mainHandItem.func_222118_a(damage, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
    }

    private void applyHoeHitCost(LivingEntity attacker) {
        ItemStack mainHandItem = attacker.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof Hoe) {
            Hoe hoe = (Hoe)mainHandItem.func_77973_b();
            int damage = hoe.durabilityMultiplier;
            mainHandItem.func_222118_a(damage, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
    }
}

