/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class Tools {
    public static Random r = new Random();

    public static void knockback(Entity entity, BlockPos sourcepoint, float amount) {
        double ratiox = (double)sourcepoint.func_177958_n() - entity.func_226277_ct_();
        double ratioz = (double)sourcepoint.func_177952_p() - entity.func_226281_cx_();
        float strength = amount;
        if (entity instanceof LivingEntity) {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)((LivingEntity)entity), (float)amount, (double)ratiox, (double)ratioz);
            if (!event.isCanceled()) {
                strength = event.getStrength();
                ratiox = event.getRatioX();
                ratioz = event.getRatioZ();
            }
            strength = (float)((double)strength * (1.0 - ((LivingEntity)entity).func_233637_b_(Attributes.field_233820_c_)));
        }
        if (!(strength <= 0.0f)) {
            entity.field_70160_al = true;
            Vector3d vector3d = entity.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(ratiox, 0.0, ratioz).func_72432_b().func_186678_a((double)strength);
            entity.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, entity.func_233570_aj_() ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)strength) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
        }
    }

    public static int countItem(PlayerEntity player, Item item) {
        int i = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            i += stack.func_190916_E();
        }
        return i;
    }

    public static boolean isHolding(PlayerEntity player, Item item) {
        return player.func_184614_ca().func_77973_b() == item || player.func_184592_cb().func_77973_b() == item;
    }

    public static boolean hasItem(PlayerEntity player, Item item, int amount) {
        int i = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item || (i += stack.func_190916_E()) < amount) continue;
            return true;
        }
        return i >= amount;
    }

    public static ItemStack getItemIfPresent(PlayerEntity player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean handNotEmpty(PlayerEntity player, Hand hand) {
        return player.func_184586_b(hand) != null && !player.func_184586_b(hand).func_190926_b();
    }

    public static boolean hasEquipped(PlayerEntity player, Item armour) {
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_77973_b() != armour) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getIfHolding(PlayerEntity player, Item item) {
        if (player.func_184614_ca().func_77973_b() == item) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() == item) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static void message(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), Util.field_240973_b_);
        }
    }

    public static void addEffect(LivingEntity entity, Effect effect, int amp, int seconds, boolean showparticles) {
        entity.func_195064_c(new EffectInstance(effect, seconds * 20, amp, !showparticles, showparticles));
    }

    public static void addPlayerModifier(PlayerEntity player, Attribute attribute, AttributeModifier modifier) {
        if (!player.func_110148_a(attribute).func_180374_a(modifier)) {
            player.func_110148_a(attribute).func_233769_c_(modifier);
        }
    }

    public static void removePlayerModifier(PlayerEntity player, Attribute attribute, AttributeModifier modifier) {
        if (player.func_110148_a(attribute).func_180374_a(modifier)) {
            player.func_110148_a(attribute).func_111124_b(modifier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(World world, Random r, double x, double y, double z, IParticleData particle, int amount, double velocity) {
        for (int i = 0; i < amount; ++i) {
            world.func_195589_b(particle, x + (double)r.nextFloat(), y + (double)r.nextFloat(), z + (double)r.nextFloat(), (-0.5 + r.nextDouble()) * velocity, (-0.5 + r.nextDouble()) * velocity, (-0.5 + r.nextDouble()) * velocity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Entity target, IParticleData particle, int amount, double velocity) {
        Tools.spawnParticles(target.field_70170_p, r, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), particle, amount, velocity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Entity target, IParticleData particle, int amount) {
        Tools.spawnParticles(target.field_70170_p, r, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), particle, amount, 1.0);
    }
}

