/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.world.gen;

import com.devmaster.dangerzone.util.RegistryHandler;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModOregen {
    public static void handleWorldGen(BiomeLoadingEvent event) {
        ModOregen.spawnOreInAllBiomes(OreType.ALUMINIUM_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.ABYSSAL_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.COARSE_AETHYST_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.LEATHER_BLOCK, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.BUTTERFLY_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.MUTANT_ZOMBIE_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.PLAY_BUTTON_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.RAINBOW_ANT_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.REDROSEWARRIOR_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.STAMPYLONGNOSE_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.TEWTIY_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.ZOMBIE_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.SALT_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.SAPPHIRE_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.TITANIUM_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.CATS_EYE_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.GODZILLA_ORE, event, Dimension.field_236053_b_.toString());
        ModOregen.spawnOreInAllBiomes(OreType.TERMITE_ORE, event, Dimension.field_236053_b_.toString());
    }

    private static OreFeatureConfig getOverworldFeatureConfig(OreType ore) {
        return new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ore.getBlock().get()).func_176223_P(), ore.getMaxVeinSize());
    }

    private static OreFeatureConfig getNetherFeatureConfig(OreType ore) {
        return new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)ore.getBlock().get()).func_176223_P(), ore.getMaxVeinSize());
    }

    private static OreFeatureConfig getEndFeatureConfig(OreType ore) {
        return new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(Blocks.field_150377_bs), ((Block)ore.getBlock().get()).func_176223_P(), ore.getMaxVeinSize());
    }

    private static ConfiguredFeature<?, ?> makeOreFeature(OreType ore, String dimensionToSpawnIn) {
        OreFeatureConfig oreFeatureConfig = null;
        if (dimensionToSpawnIn.equals(Dimension.field_236053_b_.toString())) {
            oreFeatureConfig = ModOregen.getOverworldFeatureConfig(ore);
        } else if (dimensionToSpawnIn.equals(Dimension.field_236054_c_.toString())) {
            oreFeatureConfig = ModOregen.getNetherFeatureConfig(ore);
        } else if (dimensionToSpawnIn.equals(Dimension.field_236055_d_.toString())) {
            oreFeatureConfig = ModOregen.getEndFeatureConfig(ore);
        }
        ConfiguredPlacement configuredPlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(ore.getMinHeight(), ore.getMinHeight(), ore.getMaxHeight()));
        return ModOregen.registerOreFeature(ore, oreFeatureConfig, configuredPlacement);
    }

    private static void spawnOreInOverworldInGivenBiomes(OreType ore, BiomeLoadingEvent event, Biome ... biomesToSpawnIn) {
        OreFeatureConfig oreFeatureConfig = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ore.getBlock().get()).func_176223_P(), ore.getMaxVeinSize());
        ConfiguredPlacement configuredPlacement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(ore.getMinHeight(), ore.getMinHeight(), ore.getMaxHeight()));
        ConfiguredFeature<?, ?> oreFeature = ModOregen.registerOreFeature(ore, oreFeatureConfig, configuredPlacement);
        if (Arrays.stream(biomesToSpawnIn).anyMatch(b -> b.getRegistryName().equals((Object)event.getName()))) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, oreFeature);
        }
    }

    private static void spawnOreInSpecificModBiome(Biome biomeToSpawnIn, OreType currentOreType, BiomeLoadingEvent event, String dimension) {
        if (event.getName().toString().contains(biomeToSpawnIn.getRegistryName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ModOregen.makeOreFeature(currentOreType, dimension));
        }
    }

    private static void spawnOreInSpecificBiome(RegistryKey<Biome> biomeToSpawnIn, OreType currentOreType, BiomeLoadingEvent event, String dimension) {
        if (event.getName().toString().contains(biomeToSpawnIn.func_240901_a_().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ModOregen.makeOreFeature(currentOreType, dimension));
        }
    }

    private static void spawnOreInAllBiomes(OreType currentOreType, BiomeLoadingEvent event, String dimension) {
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ModOregen.makeOreFeature(currentOreType, dimension));
    }

    private static ConfiguredFeature<?, ?> registerOreFeature(OreType ore, OreFeatureConfig oreFeatureConfig, ConfiguredPlacement configuredPlacement) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)((Block)ore.getBlock().get()).getRegistryName(), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreFeatureConfig).func_227228_a_(configuredPlacement).func_242728_a()).func_242731_b(ore.getVeinsPerChunk()));
    }

    public static enum OreType {
        ALUMINIUM_ORE((Lazy<Block>)Lazy.of(RegistryHandler.ALUMINIUM_ORE_BLOCK), 9, 0, 59, 5),
        ABYSSAL_ORE((Lazy<Block>)Lazy.of(RegistryHandler.ABYSSAL_ORE_BLOCK), 18, 16, 128, 16),
        COARSE_AETHYST_ORE((Lazy<Block>)Lazy.of(RegistryHandler.COARSE_AMETHYST_ORE_BLOCK), 6, 0, 25, 2),
        LEATHER_BLOCK((Lazy<Block>)Lazy.of(RegistryHandler.LEATHER_BLOCK), 4, 0, 128, 4),
        BUTTERFLY_ORE((Lazy<Block>)Lazy.of(RegistryHandler.BUTTERFLY_EGG_ORE), 3, 0, 128, 3),
        MUTANT_ZOMBIE_ORE((Lazy<Block>)Lazy.of(RegistryHandler.MUTANT_ZOMBIE_EGG_ORE), 3, 0, 128, 3),
        PLAY_BUTTON_ORE((Lazy<Block>)Lazy.of(RegistryHandler.PLAY_BUTTON_ORE_BLOCK), 8, 0, 14, 16),
        RAINBOW_ANT_ORE((Lazy<Block>)Lazy.of(RegistryHandler.RAINBOW_ANT_EGG_ORE), 3, 0, 128, 3),
        REDROSEWARRIOR_ORE((Lazy<Block>)Lazy.of(RegistryHandler.REDROSEWARRIOR_EGG_ORE), 3, 0, 128, 3),
        STAMPYLONGNOSE_ORE((Lazy<Block>)Lazy.of(RegistryHandler.STAMPYLONGNOSE_EGG_ORE), 3, 0, 128, 3),
        TEWTIY_ORE((Lazy<Block>)Lazy.of(RegistryHandler.TEWTIY_EGG_ORE), 3, 0, 128, 3),
        ZOMBIE_ORE((Lazy<Block>)Lazy.of(RegistryHandler.ZOMBIE_EGG_ORE), 3, 0, 128, 3),
        SALT_ORE((Lazy<Block>)Lazy.of(RegistryHandler.SALT_ORE_BLOCK), 12, 50, 128, 5),
        SAPPHIRE_ORE((Lazy<Block>)Lazy.of(RegistryHandler.SAPPHIRE_ORE_BLOCK), 6, 0, 25, 2),
        TITANIUM_ORE((Lazy<Block>)Lazy.of(RegistryHandler.TITANIUM_ORE_BLOCK), 4, 0, 20, 3),
        CATS_EYE_ORE((Lazy<Block>)Lazy.of(RegistryHandler.CATS_EYE_ORE), 7, 1, 48, 5),
        GODZILLA_ORE((Lazy<Block>)Lazy.of(RegistryHandler.GODZILLA_EGG_ORE), 3, 0, 128, 3),
        TERMITE_ORE((Lazy<Block>)Lazy.of(RegistryHandler.TERMITE_EGG_ORE), 3, 0, 128, 3);

        private final Lazy<Block> block;
        private final int maxVeinSize;
        private final int minHeight;
        private final int maxHeight;
        private final int veinsPerChunk;

        private OreType(Lazy<Block> block, int maxVeinSize, int minHeight, int maxHeight, int veinsPerChunk) {
            this.block = block;
            this.maxVeinSize = maxVeinSize;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.veinsPerChunk = veinsPerChunk;
        }

        public int getVeinsPerChunk() {
            return this.veinsPerChunk;
        }

        public Lazy<Block> getBlock() {
            return this.block;
        }

        public int getMaxVeinSize() {
            return this.maxVeinSize;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }
    }
}

