/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.world.teleportors;

import com.devmaster.dangerzone.util.RegistryHandler;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class DangerTeleporter
implements ITeleporter {
    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = this.placeInWorld(destWorld, entity, entity.func_233580_cy_(), entity instanceof PlayerEntity);
        pos = this.moveToSafeCoords(destWorld, entity, pos != null ? new BlockPos(pos.field_222505_a) : entity.func_233580_cy_());
        return pos;
    }

    @Nullable
    private PortalInfo placeInWorld(ServerWorld destWorld, Entity entity, BlockPos pos, boolean isPlayer) {
        boolean isToOverworld = destWorld.func_234923_W_() == World.field_234918_g_;
        boolean isFromDanger = entity.field_70170_p.func_234923_W_() == RegistryHandler.DANGER && isToOverworld;
        BlockPos blockpos = destWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, destWorld.func_241135_u_());
        if (!isFromDanger) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int y = 255; y >= 1; --y) {
                blockpos$mutable.func_177982_a(blockpos.func_177958_n(), y, blockpos.func_177952_p());
                if (destWorld.func_180495_p((BlockPos)blockpos$mutable).func_196958_f()) continue;
                blockpos = blockpos$mutable;
                break;
            }
        }
        float angle = entity.field_70176_ah;
        if (isPlayer && entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
            BlockPos respawnPos = serverPlayer.func_233580_cy_();
            float respawnAngle = serverPlayer.func_213302_cg();
            Optional optional = serverPlayer != null && respawnPos != null ? PlayerEntity.func_242374_a((ServerWorld)destWorld, (BlockPos)respawnPos, (float)respawnAngle, (boolean)false, (boolean)false) : Optional.empty();
            if (optional.isPresent()) {
                float f1;
                BlockState blockstate = destWorld.func_180495_p(respawnPos);
                boolean blockIsRespawnAnchor = blockstate.equals(Blocks.field_235400_nj_);
                Vector3d vector3d = (Vector3d)optional.get();
                if (!blockstate.equals(BlockTags.field_219747_F) && !blockIsRespawnAnchor) {
                    f1 = respawnAngle;
                } else {
                    Vector3d vector3d1 = Vector3d.func_237492_c_((Vector3i)respawnPos).func_178788_d(vector3d).func_72432_b();
                    f1 = (float)MathHelper.func_76138_g((double)(MathHelper.func_181159_b((double)vector3d1.field_72449_c, (double)vector3d1.field_72450_a) * 57.2957763671875 - 90.0));
                }
                angle = f1;
                blockpos = new BlockPos(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
        }
        return new PortalInfo(new Vector3d((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5), entity.func_213322_ci(), angle, (float)entity.field_70176_ah);
    }

    private PortalInfo moveToSafeCoords(ServerWorld world, Entity entity, BlockPos pos) {
        boolean toDanger;
        boolean bl = toDanger = world.func_234923_W_() == RegistryHandler.DANGER;
        if (toDanger) {
            if (!world.func_204610_c(pos).func_206888_e()) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int n = pos.func_177952_p();
            }
            return this.makePortalInfo(entity, pos.func_177958_n(), pos.func_177956_o() + 70, pos.func_177952_p());
        }
        return this.makePortalInfo(entity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (!(entity instanceof PlayerEntity)) {
            throw new IllegalArgumentException("This teleporter can only teleport players");
        }
        entity.field_70143_R = 0.0f;
        return repositionEntity.apply(false);
    }

    private PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return this.makePortalInfo(entity, new Vector3d(x, y, z));
    }

    private PortalInfo makePortalInfo(Entity entity, Vector3d pos) {
        return new PortalInfo(pos, Vector3d.field_186680_a, entity.field_70177_z, (float)entity.field_70176_ah);
    }
}

