/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.dailyrewards999;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DailyRewards999
extends JavaPlugin
implements Listener,
TabExecutor {
    private File dataFile;
    private YamlConfiguration dataConfig;
    private long claimCooldownSeconds;
    private LinkedHashMap<Integer, Reward> rewardsMap;
    private static final String PERMISSION_DAILY_USE = "daily.use";
    private static final String INVENTORY_TITLE = String.valueOf(ChatColor.DARK_GREEN) + "Daily Rewards";
    private static final Material CLAIMABLE_PANE_MATERIAL = Material.GREEN_STAINED_GLASS_PANE;
    private static final Material UNCLAIMED_PANE_MATERIAL = Material.RED_STAINED_GLASS_PANE;
    private static final String DATA_FILE_NAME = "data.yml";
    private static final Pattern REWARD_PATTERN = Pattern.compile("^([A-Z_]+) \\((\\d+)\\)$");

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.setupDataFile();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("daily").setExecutor((CommandExecutor)this);
        this.getCommand("daily").setTabCompleter((TabCompleter)this);
        this.getLogger().info("DailyRewards999 enabled.");
    }

    public void onDisable() {
        this.saveDataFile();
        this.getLogger().info("DailyRewards999 disabled.");
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.claimCooldownSeconds = config.getLong("claim_cooldown_seconds", 86400L);
        this.rewardsMap = new LinkedHashMap();
        ConfigurationSection rewardsSection = config.getConfigurationSection("rewards");
        if (rewardsSection == null) {
            this.getLogger().warning("No rewards section found in config.yml!");
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(rewardsSection.getKeys(false));
        keys.sort(Comparator.comparingInt(this::extractDayNumber));
        for (String key : keys) {
            String rewardString = rewardsSection.getString(key);
            int day = this.extractDayNumber(key);
            if (day < 1) {
                this.getLogger().warning("Invalid reward day key: " + key);
                continue;
            }
            Reward reward = this.parseReward(rewardString);
            if (reward == null) {
                this.getLogger().warning("Invalid reward format for " + key + ": " + rewardString);
                continue;
            }
            this.rewardsMap.put(day, reward);
        }
    }

    private int extractDayNumber(String key) {
        if (key == null) {
            return -1;
        }
        if (!key.toLowerCase().startsWith("day")) {
            return -1;
        }
        try {
            return Integer.parseInt(key.substring(3));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private Reward parseReward(String rewardString) {
        int amount;
        if (rewardString == null) {
            return null;
        }
        Matcher matcher = REWARD_PATTERN.matcher(rewardString.trim());
        if (!matcher.matches()) {
            return null;
        }
        String materialName = matcher.group(1);
        try {
            amount = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return null;
        }
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            return null;
        }
        if (amount < 1) {
            amount = 1;
        }
        return new Reward(material, amount);
    }

    private void setupDataFile() {
        this.dataFile = new File(this.getDataFolder(), DATA_FILE_NAME);
        if (!this.dataFile.exists()) {
            try {
                this.getDataFolder().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create data file: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveDataFile() {
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save data file: " + e.getMessage());
        }
    }

    private PlayerData getPlayerData(UUID uuid) {
        String uuidString = uuid.toString();
        long lastClaim = this.dataConfig.getLong(uuidString + ".lastClaim", 0L);
        int streakDay = this.dataConfig.getInt(uuidString + ".streakDay", 0);
        return new PlayerData(lastClaim, streakDay);
    }

    private void setPlayerData(UUID uuid, PlayerData data) {
        String uuidString = uuid.toString();
        this.dataConfig.set(uuidString + ".lastClaim", (Object)data.lastClaim);
        this.dataConfig.set(uuidString + ".streakDay", (Object)data.streakDay);
        this.saveDataFile();
    }

    private void resetPlayerData(UUID uuid) {
        String path = uuid.toString();
        this.dataConfig.set(path, null);
        this.saveDataFile();
    }

    private boolean hasPermission(Player player) {
        return player.hasPermission(PERMISSION_DAILY_USE);
    }

    private int getMaxDay() {
        if (this.rewardsMap.isEmpty()) {
            return 0;
        }
        return Collections.max(this.rewardsMap.keySet());
    }

    private Inventory createDailyInventory(Player player) {
        int nextDayToClaim;
        long daysBetween;
        int maxDay = this.getMaxDay();
        if (maxDay == 0) {
            return null;
        }
        int size = ((maxDay - 1) / 9 + 1) * 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)INVENTORY_TITLE);
        PlayerData pdata = this.getPlayerData(player.getUniqueId());
        long now = Instant.now().getEpochSecond();
        LocalDate today = LocalDate.now();
        LocalDate lastClaimDate = pdata.lastClaim > 0L ? LocalDate.ofEpochDay(pdata.lastClaim / 86400L) : null;
        boolean missedDay = false;
        if (lastClaimDate != null && (daysBetween = ChronoUnit.DAYS.between(lastClaimDate, today)) > 1L) {
            missedDay = true;
        }
        int currentStreakDisplay = pdata.streakDay;
        if (missedDay || pdata.lastClaim == 0L) {
            currentStreakDisplay = 0;
        }
        if ((nextDayToClaim = currentStreakDisplay + 1) > maxDay) {
            nextDayToClaim = 1;
        }
        boolean canClaimNext = now - pdata.lastClaim >= this.claimCooldownSeconds;
        for (int day = 1; day <= maxDay; ++day) {
            String displayName;
            ItemStack pane;
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (day <= pdata.streakDay && !missedDay) {
                pane = new ItemStack(CLAIMABLE_PANE_MATERIAL);
                displayName = String.valueOf(ChatColor.GREEN) + "Day " + day + " - Claimed";
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "You have claimed this reward.")));
                reward = this.rewardsMap.get(day);
                if (reward != null) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Reward: " + reward.toString())));
                }
            } else if (day == nextDayToClaim && canClaimNext) {
                pane = new ItemStack(CLAIMABLE_PANE_MATERIAL);
                displayName = String.valueOf(ChatColor.GREEN) + "Day " + day + " - Click to claim!";
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Click to claim your reward.")));
                reward = this.rewardsMap.get(day);
                if (reward != null) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Reward: " + reward.toString())));
                }
            } else {
                pane = new ItemStack(UNCLAIMED_PANE_MATERIAL);
                displayName = String.valueOf(ChatColor.RED) + "Day " + day;
                if (day == 1 && missedDay) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Your streak was reset due to inactivity.")));
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Claim Day 1 to start again.")));
                } else {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Not claimable yet.")));
                }
                reward = this.rewardsMap.get(day);
                if (reward != null) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Reward: " + reward.toString())));
                }
            }
            ItemMeta meta = pane.getItemMeta();
            meta.setDisplayName(displayName);
            meta.setLore(lore);
            pane.setItemMeta(meta);
            inv.setItem(day - 1, pane);
        }
        return inv;
    }

    private void giveReward(Player player, Reward reward) {
        ItemStack item = new ItemStack(reward.material, reward.amount);
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftover.isEmpty()) {
            leftover.values().forEach(i -> player.getWorld().dropItemNaturally(player.getLocation(), i));
        }
    }

    private void handleClaim(Player player, int day) {
        int targetDay;
        long daysBetween;
        UUID uuid = player.getUniqueId();
        PlayerData pdata = this.getPlayerData(uuid);
        long now = Instant.now().getEpochSecond();
        LocalDate today = LocalDate.now();
        LocalDate lastClaimDate = pdata.lastClaim > 0L ? LocalDate.ofEpochDay(pdata.lastClaim / 86400L) : null;
        boolean missedDay = false;
        if (lastClaimDate != null && (daysBetween = ChronoUnit.DAYS.between(lastClaimDate, today)) > 1L) {
            missedDay = true;
        }
        if (day != (targetDay = missedDay || pdata.lastClaim == 0L ? 1 : pdata.streakDay + 1)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot claim this reward right now. Expected Day " + targetDay + ".");
            return;
        }
        if (pdata.lastClaim > 0L && now - pdata.lastClaim < this.claimCooldownSeconds) {
            long wait = this.claimCooldownSeconds - (now - pdata.lastClaim);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + this.formatSeconds(wait) + " before claiming the next reward.");
            return;
        }
        Reward reward = this.rewardsMap.get(day);
        if (reward == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid reward day.");
            return;
        }
        this.giveReward(player, reward);
        pdata.lastClaim = now;
        if (missedDay || pdata.lastClaim == 0L) {
            pdata.streakDay = 1;
            if (missedDay) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your streak was reset! Starting a new streak from Day 1.");
            }
        } else {
            ++pdata.streakDay;
        }
        this.setPlayerData(uuid, pdata);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You claimed your Day " + day + " reward: " + reward.toString());
        player.closeInventory();
    }

    private String formatSeconds(long seconds) {
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (h > 0L) {
            sb.append(h).append("h ");
        }
        if (m > 0L) {
            sb.append(m).append("m ");
        }
        sb.append(s).append("s");
        return sb.toString();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.hasPermission(player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (command.getName().equalsIgnoreCase("daily")) {
            Inventory inv = this.createDailyInventory(player);
            if (inv == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No rewards configured.");
                return true;
            }
            player.openInventory(inv);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().equals(INVENTORY_TITLE)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        if (!clicked.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        if (displayName == null) {
            return;
        }
        if (!displayName.contains("Click to claim")) {
            return;
        }
        int day = this.extractDayFromDisplayName(displayName);
        if (day < 1) {
            return;
        }
        this.handleClaim(player, day);
    }

    private int extractDayFromDisplayName(String displayName) {
        String plain = ChatColor.stripColor((String)displayName);
        if (!plain.toLowerCase().startsWith("day ")) {
            return -1;
        }
        try {
            String[] parts = plain.split(" ");
            return Integer.parseInt(parts[1]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static class Reward {
        final Material material;
        final int amount;

        Reward(Material material, int amount) {
            this.material = material;
            this.amount = amount;
        }

        public String toString() {
            return this.material.name() + " (" + this.amount + ")";
        }
    }

    private static class PlayerData {
        long lastClaim;
        int streakDay;

        PlayerData(long lastClaim, int streakDay) {
            this.lastClaim = lastClaim;
            this.streakDay = streakDay;
        }
    }
}

