/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.dailyrewards999;

import com.yourname.dailyrewards999.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DailyRewards999
extends JavaPlugin
implements Listener,
TabExecutor {
    private File dataFile;
    private YamlConfiguration dataConfig;
    private long claimCooldownSeconds;
    private int guiRows;
    private Material fillItemMaterial;
    private List<String> claimedItemLore;
    private List<String> unclaimedItemLore;
    private LinkedHashMap<Integer, Reward> rewardsMap;
    private List<Reward> randomRewards;
    private boolean randomRewardsEnabled;
    private boolean autoUpdateEnabled;
    private boolean autoDownloadUpdate;
    private String prefix;
    private String claimedRewardMessage;
    private String alreadyClaimedMessage;
    private String noPermissionMessage;
    private String streakResetMessage;
    private static final String PERMISSION_DAILY_USE = "daily.use";
    private static final String INVENTORY_TITLE = String.valueOf(ChatColor.DARK_GREEN) + "Daily Rewards";
    private static final Material CLAIMABLE_PANE_MATERIAL = Material.GREEN_STAINED_GLASS_PANE;
    private static final Material UNCLAIMED_PANE_MATERIAL = Material.RED_STAINED_GLASS_PANE;
    private static final String DATA_FILE_NAME = "data.yml";
    private static final Pattern REWARD_PATTERN = Pattern.compile("^([A-Z_]+) \\((\\d+)\\)$");

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.setupDataFile();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("daily").setExecutor((CommandExecutor)this);
        this.getCommand("daily").setTabCompleter((TabCompleter)this);
        this.getCommand("dailyrewards999").setExecutor((CommandExecutor)this);
        this.getCommand("dailyrewards999").setTabCompleter((TabCompleter)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new DailyRewardsPlaceholderExpansion(this).register();
        }
        if (this.autoUpdateEnabled) {
            new UpdateChecker(this, "dailyrewards999", this.getDescription().getVersion(), this.autoDownloadUpdate).checkForUpdates();
        }
        this.getLogger().info("DailyRewards999 enabled.");
    }

    public void onDisable() {
        this.saveDataFile();
        this.getLogger().info("DailyRewards999 disabled.");
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.claimCooldownSeconds = config.getLong("claim_cooldown_seconds", 86400L);
        this.guiRows = config.getInt("gui_rows", 3);
        if (this.guiRows < 1 || this.guiRows > 6) {
            this.getLogger().warning("Invalid gui_rows value in config.yml. Must be between 1 and 6. Defaulting to 3.");
            this.guiRows = 3;
        }
        String fillItemName = config.getString("fill_item", "GRAY_STAINED_GLASS_PANE");
        this.fillItemMaterial = Material.getMaterial((String)fillItemName);
        if (this.fillItemMaterial == null) {
            this.getLogger().warning("Invalid fill_item material in config.yml. Defaulting to GRAY_STAINED_GLASS_PANE.");
            this.fillItemMaterial = Material.GRAY_STAINED_GLASS_PANE;
        }
        this.claimedItemLore = config.getStringList("claimed_item_lore");
        this.unclaimedItemLore = config.getStringList("unclaimed_item_lore");
        this.rewardsMap = new LinkedHashMap();
        ConfigurationSection rewardsSection = config.getConfigurationSection("rewards");
        if (rewardsSection == null) {
            this.getLogger().warning("No rewards section found in config.yml!");
            return;
        }
        this.randomRewardsEnabled = config.getBoolean("random_rewards.enabled", false);
        this.randomRewards = new ArrayList<Reward>();
        if (this.randomRewardsEnabled) {
            List randomRewardStrings = config.getStringList("random_rewards.rewards");
            for (String rewardString : randomRewardStrings) {
                Reward reward = this.parseReward(rewardString);
                if (reward != null) {
                    this.randomRewards.add(reward);
                    continue;
                }
                this.getLogger().warning("Invalid random reward format: " + rewardString);
            }
        }
        ArrayList<String> keys = new ArrayList<String>(rewardsSection.getKeys(false));
        keys.sort(Comparator.comparingInt(this::extractDayNumber));
        for (String key : keys) {
            String rewardString = rewardsSection.getString(key);
            int day = this.extractDayNumber(key);
            if (day < 1) {
                this.getLogger().warning("Invalid reward day key: " + key);
                continue;
            }
            if (rewardString.equalsIgnoreCase("random")) {
                this.rewardsMap.put(day, null);
                continue;
            }
            Reward reward = this.parseReward(rewardString);
            if (reward == null) {
                this.getLogger().warning("Invalid reward format for " + key + ": " + rewardString);
                continue;
            }
            this.rewardsMap.put(day, reward);
        }
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.prefix", "&6[&bDailyRewards&6] "));
        this.claimedRewardMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.claimed_reward", "&aYou have claimed your daily reward!"));
        this.alreadyClaimedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.already_claimed", "&cYou have already claimed your daily reward. Come back in %time%!"));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no_permission", "&cYou do not have permission to claim this reward."));
        this.streakResetMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.streak_reset", "&cYour daily reward streak has been reset! Claim Day 1 to start a new streak."));
        this.autoUpdateEnabled = config.getBoolean("auto_update.enabled", true);
        this.autoDownloadUpdate = config.getBoolean("auto_update.auto_download", true);
    }

    private int extractDayNumber(String key) {
        if (key == null) {
            return -1;
        }
        if (!key.toLowerCase().startsWith("day")) {
            return -1;
        }
        try {
            return Integer.parseInt(key.substring(3));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private Reward parseReward(String rewardString) {
        int amount;
        if (rewardString == null) {
            return null;
        }
        Matcher matcher = REWARD_PATTERN.matcher(rewardString.trim());
        if (!matcher.matches()) {
            return null;
        }
        String materialName = matcher.group(1);
        try {
            amount = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return null;
        }
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            return null;
        }
        if (amount < 1) {
            amount = 1;
        }
        return new Reward(material, amount);
    }

    private void setupDataFile() {
        this.dataFile = new File(this.getDataFolder(), DATA_FILE_NAME);
        if (!this.dataFile.exists()) {
            try {
                this.getDataFolder().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create data file: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveDataFile() {
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save data file: " + e.getMessage());
        }
    }

    private PlayerData getPlayerData(UUID uuid) {
        String uuidString = uuid.toString();
        long lastClaim = this.dataConfig.getLong(uuidString + ".lastClaim", 0L);
        int streakDay = this.dataConfig.getInt(uuidString + ".streakDay", 0);
        return new PlayerData(lastClaim, streakDay);
    }

    private void setPlayerData(UUID uuid, PlayerData data) {
        String uuidString = uuid.toString();
        this.dataConfig.set(uuidString + ".lastClaim", (Object)data.lastClaim);
        this.dataConfig.set(uuidString + ".streakDay", (Object)data.streakDay);
        this.saveDataFile();
    }

    private void resetPlayerData(UUID uuid) {
        String path = uuid.toString();
        this.dataConfig.set(path, null);
        this.saveDataFile();
    }

    private boolean hasPermission(Player player) {
        return player.hasPermission(PERMISSION_DAILY_USE);
    }

    private int getMaxDay() {
        if (this.rewardsMap.isEmpty()) {
            return 0;
        }
        return Collections.max(this.rewardsMap.keySet());
    }

    private Inventory createDailyInventory(Player player) {
        int nextDayToClaim;
        long daysBetween;
        int maxDay = this.getMaxDay();
        if (maxDay == 0) {
            return null;
        }
        int size = this.guiRows * 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)INVENTORY_TITLE);
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, new ItemStack(this.fillItemMaterial));
        }
        PlayerData pdata = this.getPlayerData(player.getUniqueId());
        long now = Instant.now().getEpochSecond();
        LocalDate today = LocalDate.now();
        LocalDate lastClaimDate = pdata.lastClaim > 0L ? LocalDate.ofEpochDay(pdata.lastClaim / 86400L) : null;
        boolean missedDay = false;
        if (lastClaimDate != null && (daysBetween = ChronoUnit.DAYS.between(lastClaimDate, today)) > 1L) {
            missedDay = true;
        }
        int currentStreakDisplay = pdata.streakDay;
        if (missedDay || pdata.lastClaim == 0L) {
            currentStreakDisplay = 0;
        }
        if ((nextDayToClaim = currentStreakDisplay + 1) > maxDay) {
            nextDayToClaim = 1;
        }
        boolean canClaimNext = now - pdata.lastClaim >= this.claimCooldownSeconds;
        for (int day = 1; day <= maxDay; ++day) {
            String displayName;
            ItemStack pane;
            String rewardString;
            ArrayList<Object> lore = new ArrayList<Object>();
            Reward reward = this.rewardsMap.get(day);
            String string = rewardString = reward != null ? reward.toString() : "Random Reward";
            if (day <= pdata.streakDay && !missedDay) {
                pane = new ItemStack(CLAIMABLE_PANE_MATERIAL);
                displayName = String.valueOf(ChatColor.GREEN) + "Day " + day + " - Claimed";
                for (String line : this.claimedItemLore) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("%reward_item%", rewardString)));
                }
            } else if (day == nextDayToClaim && canClaimNext) {
                pane = new ItemStack(CLAIMABLE_PANE_MATERIAL);
                displayName = String.valueOf(ChatColor.GREEN) + "Day " + day + " - Click to claim!";
                lore.add(String.valueOf(ChatColor.YELLOW) + "Click to claim your reward.");
                for (String line : this.unclaimedItemLore) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("%reward_item%", rewardString)));
                }
            } else {
                pane = new ItemStack(UNCLAIMED_PANE_MATERIAL);
                displayName = String.valueOf(ChatColor.RED) + "Day " + day;
                if (day == 1 && missedDay) {
                    lore.add(ChatColor.stripColor((String)this.streakResetMessage));
                    lore.add(String.valueOf(ChatColor.GRAY) + "Claim Day 1 to start again.");
                } else {
                    for (String line : this.unclaimedItemLore) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("%reward_item%", rewardString)));
                    }
                }
            }
            ItemMeta meta = pane.getItemMeta();
            meta.setDisplayName(displayName);
            meta.setLore(lore);
            pane.setItemMeta(meta);
            inv.setItem(day - 1, pane);
        }
        return inv;
    }

    private void giveReward(Player player, Reward reward) {
        ItemStack item = new ItemStack(reward.material, reward.amount);
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftover.isEmpty()) {
            leftover.values().forEach(i -> player.getWorld().dropItemNaturally(player.getLocation(), i));
        }
    }

    private void handleClaim(Player player, int day) {
        int targetDay;
        long daysBetween;
        UUID uuid = player.getUniqueId();
        PlayerData pdata = this.getPlayerData(uuid);
        long now = Instant.now().getEpochSecond();
        LocalDate today = LocalDate.now();
        LocalDate lastClaimDate = pdata.lastClaim > 0L ? LocalDate.ofEpochDay(pdata.lastClaim / 86400L) : null;
        boolean missedDay = false;
        if (lastClaimDate != null && (daysBetween = ChronoUnit.DAYS.between(lastClaimDate, today)) > 1L) {
            missedDay = true;
        }
        if (day != (targetDay = missedDay || pdata.lastClaim == 0L ? 1 : pdata.streakDay + 1)) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You cannot claim this reward right now. Expected Day " + targetDay + ".");
            return;
        }
        if (pdata.lastClaim > 0L && now - pdata.lastClaim < this.claimCooldownSeconds) {
            long wait = this.claimCooldownSeconds - (now - pdata.lastClaim);
            player.sendMessage(this.prefix + this.alreadyClaimedMessage.replace("%time%", this.formatSeconds(wait)));
            return;
        }
        Reward reward = this.rewardsMap.get(day);
        if (reward == null) {
            if (this.randomRewardsEnabled && !this.randomRewards.isEmpty()) {
                Random rand = new Random();
                reward = this.randomRewards.get(rand.nextInt(this.randomRewards.size()));
            } else {
                player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Random rewards are not configured or enabled.");
                return;
            }
        }
        this.giveReward(player, reward);
        pdata.lastClaim = now;
        if (missedDay || pdata.lastClaim == 0L) {
            pdata.streakDay = 1;
            if (missedDay) {
                player.sendMessage(this.prefix + this.streakResetMessage);
            }
        } else {
            ++pdata.streakDay;
        }
        this.setPlayerData(uuid, pdata);
        player.sendMessage(this.prefix + this.claimedRewardMessage.replace("%day%", String.valueOf(day)).replace("%reward_item%", reward.toString()));
        player.closeInventory();
    }

    private String formatSeconds(long seconds) {
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (h > 0L) {
            sb.append(h).append("h ");
        }
        if (m > 0L) {
            sb.append(m).append("m ");
        }
        sb.append(s).append("s");
        return sb.toString();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.hasPermission(player)) {
            player.sendMessage(this.prefix + this.noPermissionMessage);
            return true;
        }
        if (command.getName().equalsIgnoreCase("daily")) {
            Inventory inv = this.createDailyInventory(player);
            if (inv == null) {
                player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "No rewards configured.");
                return true;
            }
            player.openInventory(inv);
            return true;
        }
        if (command.getName().equalsIgnoreCase("dailyrewards999") && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("daily.admin")) {
                player.sendMessage(this.prefix + this.noPermissionMessage);
                return true;
            }
            this.reloadConfig();
            this.loadConfigValues();
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "DailyRewards999 configuration reloaded.");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("dailyrewards999") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            return completions;
        }
        return Collections.emptyList();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().equals(INVENTORY_TITLE)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        if (!clicked.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        if (displayName == null) {
            return;
        }
        if (!displayName.contains("Click to claim")) {
            return;
        }
        int day = this.extractDayFromDisplayName(displayName);
        if (day < 1) {
            return;
        }
        this.handleClaim(player, day);
    }

    private int extractDayFromDisplayName(String displayName) {
        String plain = ChatColor.stripColor((String)displayName);
        if (!plain.toLowerCase().startsWith("day ")) {
            return -1;
        }
        try {
            String[] parts = plain.split(" ");
            return Integer.parseInt(parts[1]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private class DailyRewardsPlaceholderExpansion
    extends PlaceholderExpansion {
        private final DailyRewards999 plugin;

        public DailyRewardsPlaceholderExpansion(DailyRewards999 plugin) {
            this.plugin = plugin;
        }

        public String getIdentifier() {
            return "dailyrewards999";
        }

        public String getAuthor() {
            return this.plugin.getDescription().getAuthors().toString();
        }

        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(Player player, String identifier) {
            if (player == null) {
                return "";
            }
            PlayerData pdata = this.plugin.getPlayerData(player.getUniqueId());
            long now = Instant.now().getEpochSecond();
            if (identifier.equals("next_claim_time")) {
                long timeRemaining = pdata.lastClaim + this.plugin.claimCooldownSeconds - now;
                if (timeRemaining <= 0L) {
                    return "Ready to claim!";
                }
                return DailyRewards999.this.formatSeconds(timeRemaining);
            }
            if (identifier.equals("current_streak")) {
                long daysBetween;
                LocalDate today = LocalDate.now();
                LocalDate lastClaimDate = pdata.lastClaim > 0L ? LocalDate.ofEpochDay(pdata.lastClaim / 86400L) : null;
                boolean missedDay = false;
                if (lastClaimDate != null && (daysBetween = ChronoUnit.DAYS.between(lastClaimDate, today)) > 1L) {
                    missedDay = true;
                }
                return String.valueOf(missedDay ? 0 : pdata.streakDay);
            }
            return null;
        }
    }

    private static class Reward {
        final Material material;
        final int amount;

        Reward(Material material, int amount) {
            this.material = material;
            this.amount = amount;
        }

        public String toString() {
            return this.material.name() + " (" + this.amount + ")";
        }
    }

    private static class PlayerData {
        long lastClaim;
        int streakDay;

        PlayerData(long lastClaim, int streakDay) {
            this.lastClaim = lastClaim;
            this.streakDay = streakDay;
        }
    }
}

