/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.dailyrewards999;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String projectSlug;
    private final String currentVersion;
    private final boolean autoDownload;

    public UpdateChecker(JavaPlugin plugin, String projectSlug, String currentVersion, boolean autoDownload) {
        this.plugin = plugin;
        this.projectSlug = projectSlug;
        this.currentVersion = currentVersion;
        this.autoDownload = autoDownload;
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectSlug + "/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "DailyRewards999-Updater");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        content.append(inputLine);
                    }
                    in.close();
                    connection.disconnect();
                    String latestVersion = null;
                    String downloadUrl = null;
                    String filename = null;
                    Pattern versionPattern = Pattern.compile("\"version_number\":\"([^\"]+)\"");
                    Pattern urlPattern = Pattern.compile("\"url\":\"([^\"]+\\.jar)\"");
                    Pattern filenamePattern = Pattern.compile("\"filename\":\"([^\"]+\\.jar)\"");
                    Matcher versionMatcher = versionPattern.matcher(content.toString());
                    Matcher urlMatcher = urlPattern.matcher(content.toString());
                    Matcher filenameMatcher = filenamePattern.matcher(content.toString());
                    if (versionMatcher.find()) {
                        latestVersion = versionMatcher.group(1);
                    }
                    if (urlMatcher.find()) {
                        downloadUrl = urlMatcher.group(1);
                    }
                    if (filenameMatcher.find()) {
                        filename = filenameMatcher.group(1);
                    }
                    if (latestVersion != null && this.isNewerVersion(latestVersion, this.currentVersion)) {
                        this.plugin.getLogger().info("A new version of DailyRewards999 is available: " + latestVersion + "! (Current: " + this.currentVersion + ")");
                        this.plugin.getLogger().info("Download it from: https://modrinth.com/plugin/" + this.projectSlug);
                        if (this.autoDownload && downloadUrl != null && filename != null) {
                            this.downloadUpdate(downloadUrl, filename);
                        } else if (this.autoDownload && (downloadUrl == null || filename == null)) {
                            this.plugin.getLogger().warning("Could not automatically download update: download URL or filename not found.");
                        }
                    } else {
                        this.plugin.getLogger().info("DailyRewards999 is up to date.");
                    }
                } else {
                    this.plugin.getLogger().warning("Failed to check for updates. Response code: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error checking for updates: " + e.getMessage());
            }
        });
    }

    private void downloadUpdate(String downloadUrl, String filename) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL(downloadUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "DailyRewards999-Updater");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    File updateFolder = new File(this.plugin.getDataFolder().getParentFile(), "update");
                    if (!updateFolder.exists()) {
                        updateFolder.mkdirs();
                    }
                    File outputFile = new File(updateFolder, filename);
                    Files.copy(connection.getInputStream(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.plugin.getLogger().info("Downloaded new version to " + outputFile.getAbsolutePath() + ". Please restart your server to apply the update.");
                } else {
                    this.plugin.getLogger().warning("Failed to download update. Response code: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error downloading update: " + e.getMessage());
            }
        });
    }

    private boolean isNewerVersion(String newVersion, String oldVersion) {
        String[] newParts = newVersion.split("\\.");
        String[] oldParts = oldVersion.split("\\.");
        for (int i = 0; i < Math.max(newParts.length, oldParts.length); ++i) {
            int oldPart;
            int newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
            int n = oldPart = i < oldParts.length ? Integer.parseInt(oldParts[i]) : 0;
            if (newPart < oldPart) {
                return false;
            }
            if (newPart <= oldPart) continue;
            return true;
        }
        return false;
    }
}

