/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.forge.impl.neoforge;

import fuzs.forgeconfigapiport.forge.api.v5.NeoForgeConfigRegistry;
import fuzs.forgeconfigapiport.forge.impl.neoforge.NeoForgeConfigSpecAdapter;
import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class NeoForgeConfigRegistryImpl
implements NeoForgeConfigRegistry {
    @Override
    public void register(String modId, ModConfig.Type type, IConfigSpec spec) {
        ModContainer modContainer = this.getModContainer(modId);
        this.register(modContainer, type, spec);
    }

    @Override
    public void register(ModContainer modContainer, ModConfig.Type type, IConfigSpec spec) {
        if (spec.isEmpty()) {
            ForgeConfigAPIPort.LOGGER.debug("Attempted to register an empty config for type {} on mod {}", (Object)type, (Object)modContainer.getModId());
        } else {
            ModConfig modConfig = new ModConfig(type, (net.minecraftforge.fml.config.IConfigSpec)new NeoForgeConfigSpecAdapter(modContainer.getModId(), (ModConfigSpec)spec), modContainer);
            modContainer.addConfig(modConfig);
        }
    }

    @Override
    public void register(String modId, ModConfig.Type type, IConfigSpec spec, String fileName) {
        ModContainer modContainer = this.getModContainer(modId);
        this.register(modContainer, type, spec, fileName);
    }

    @Override
    public void register(ModContainer modContainer, ModConfig.Type type, IConfigSpec spec, String fileName) {
        if (spec.isEmpty()) {
            ForgeConfigAPIPort.LOGGER.debug("Attempted to register an empty config for type {} on mod {} using file name {}", new Object[]{type, modContainer.getModId(), fileName});
        } else {
            ModConfig modConfig = new ModConfig(type, (net.minecraftforge.fml.config.IConfigSpec)new NeoForgeConfigSpecAdapter(modContainer.getModId(), (ModConfigSpec)spec), modContainer, fileName);
            modContainer.addConfig(modConfig);
        }
    }

    private ModContainer getModContainer(String modId) {
        return (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new IllegalStateException("Invalid mod id '%s'".formatted(modId)));
    }
}

