/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import fuzs.forgeconfigapiport.fabric.impl.config.ModConfigValues;
import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class ForgeConfigApiPortConfig {
    private static final ConfigSpec configSpec = new ConfigSpec();
    private static final CommentedConfig configComments = CommentedConfig.inMemory();
    private static final ForgeConfigApiPortConfig INSTANCE;
    @Nullable
    private CommentedFileConfig configData;

    private ForgeConfigApiPortConfig() {
    }

    private void loadFrom(Path configFile) {
        this.configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile).sync().onFileNotFound(FileNotFoundAction.copyData((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/forgeconfigapiport.toml")))).writingMode(WritingMode.REPLACE).build();
        try {
            this.configData.load();
        }
        catch (ParsingException exception) {
            try {
                Files.delete(this.configData.getNioPath());
                this.configData.load();
                ForgeConfigAPIPort.LOGGER.warn("Configuration file {} could not be parsed. Correcting", (Object)this.configData.getNioPath(), (Object)exception);
            }
            catch (ParsingException parsingException) {
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to load Forge Config API Port config from " + String.valueOf(configFile), throwable);
            }
        }
        if (!configSpec.isCorrect((Config)this.configData)) {
            ForgeConfigAPIPort.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)configFile);
            configSpec.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> ForgeConfigAPIPort.LOGGER.info("Incorrect key {} was corrected from {} to {}", new Object[]{path, incorrectValue, correctedValue}));
        }
        this.configData.putAllComments((UnmodifiableCommentedConfig)configComments);
        this.configData.save();
    }

    public static void load() {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("forgeconfigapiport.toml");
        INSTANCE.loadFrom(configFile);
        ForgeConfigAPIPort.LOGGER.trace("Loaded FML config from {}", (Object)configFile);
        for (ModConfigValues cv : ModConfigValues.values()) {
            ForgeConfigAPIPort.LOGGER.trace("FMLConfig {} is {}", (Object)cv.entry, cv.getConfigValue(ForgeConfigApiPortConfig.INSTANCE.configData));
        }
        ForgeConfigApiPortConfig.getOrCreateGameRelativePath(Paths.get(ForgeConfigApiPortConfig.getConfigValue(ModConfigValues.DEFAULT_CONFIGS_PATH), new String[0]));
    }

    public static String getConfigValue(ModConfigValues v) {
        if (ForgeConfigApiPortConfig.INSTANCE.configData == null) {
            ForgeConfigApiPortConfig.load();
        }
        return (String)v.getConfigValue(ForgeConfigApiPortConfig.INSTANCE.configData);
    }

    public static boolean getBoolConfigValue(ModConfigValues v) {
        if (ForgeConfigApiPortConfig.INSTANCE.configData == null) {
            ForgeConfigApiPortConfig.load();
        }
        return (Boolean)v.getConfigValue(ForgeConfigApiPortConfig.INSTANCE.configData);
    }

    public static Path getDefaultConfigsDirectory() {
        return FabricLoader.getInstance().getGameDir().resolve(ForgeConfigApiPortConfig.getConfigValue(ModConfigValues.DEFAULT_CONFIGS_PATH));
    }

    private static Path getOrCreateGameRelativePath(Path path) {
        Path gameFolderPath = FabricLoader.getInstance().getGameDir().resolve(path);
        if (!Files.isDirectory(gameFolderPath, new LinkOption[0])) {
            try {
                Files.createDirectories(gameFolderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return gameFolderPath;
    }

    static {
        for (ModConfigValues cv : ModConfigValues.values()) {
            cv.buildConfigEntry(configSpec, configComments);
        }
        INSTANCE = new ForgeConfigApiPortConfig();
    }
}

