/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.core;

import fuzs.forgeconfigapiport.fabric.api.v5.ModConfigEvents;
import fuzs.forgeconfigapiport.fabric.impl.util.FabricEventFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.Event;
import net.neoforged.fml.config.ModConfig;

public final class ModConfigEventsHelper {
    private static final Map<String, Holder> HOLDERS_BY_MOD_ID = new ConcurrentHashMap<String, Holder>();

    private ModConfigEventsHelper() {
    }

    public static void onLoading(ModConfig modConfig) {
        ((ModConfigEvents.Loading)ModConfigEvents.loading(modConfig.getModId()).invoker()).onModConfigLoading(modConfig);
    }

    public static void onReloading(ModConfig modConfig) {
        ((ModConfigEvents.Reloading)ModConfigEvents.reloading(modConfig.getModId()).invoker()).onModConfigReloading(modConfig);
    }

    public static void onUnloading(ModConfig modConfig) {
        ((ModConfigEvents.Unloading)ModConfigEvents.unloading(modConfig.getModId()).invoker()).onModConfigUnloading(modConfig);
    }

    public static Holder get(String modId) {
        return HOLDERS_BY_MOD_ID.computeIfAbsent(modId, modIdX -> {
            Event<ModConfigEvents.Loading> loading = FabricEventFactory.create(ModConfigEvents.Loading.class);
            Event<ModConfigEvents.Reloading> reloading = FabricEventFactory.create(ModConfigEvents.Reloading.class);
            Event<ModConfigEvents.Unloading> unloading = FabricEventFactory.create(ModConfigEvents.Unloading.class);
            return new Holder(modId, loading, reloading, unloading);
        });
    }

    public record Holder(String modId, Event<ModConfigEvents.Loading> loading, Event<ModConfigEvents.Reloading> reloading, Event<ModConfigEvents.Unloading> unloading) {
    }
}

