/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.forge.impl.neoforge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeConfigSpecAdapter
extends UnmodifiableConfigWrapper<UnmodifiableConfig>
implements IConfigSpec<NeoForgeConfigSpecAdapter> {
    private static final Map<String, ReentrantLock> LOCKS_BY_MOD = new ConcurrentHashMap<String, ReentrantLock>();
    private final ModConfigSpec spec;
    private final ReentrantLock lock;

    public NeoForgeConfigSpecAdapter(String modId, ModConfigSpec spec) {
        super(spec.getSpec());
        this.spec = spec;
        this.lock = LOCKS_BY_MOD.computeIfAbsent(modId, $ -> new ReentrantLock());
        this.registerEventHandlers();
    }

    void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> ConfigTracker.INSTANCE.fileMap().values().forEach(config -> {
            if (config.getSpec() == this) {
                this.spec.resetCaches(ModConfigSpec.RestartType.WORLD);
            }
        }));
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(event -> ConfigTracker.INSTANCE.fileMap().values().forEach(config -> {
                if (config.getSpec() == this) {
                    this.spec.resetCaches(ModConfigSpec.RestartType.WORLD);
                }
            }));
        }
    }

    public void acceptConfig(final @Nullable CommentedConfig data) {
        this.lock.lock();
        this.spec.acceptConfig(data != null ? new IConfigSpec.ILoadedConfig(){

            @Override
            public CommentedConfig config() {
                return data;
            }

            @Override
            public void save() {
                if (data instanceof FileConfig) {
                    FileConfig fileConfig = (FileConfig)data;
                    new TomlWriter().write((UnmodifiableConfig)data, fileConfig.getNioPath(), WritingMode.REPLACE_ATOMIC);
                }
            }
        } : null);
        this.lock.unlock();
    }

    public boolean isCorrecting() {
        return this.lock.isLocked();
    }

    public boolean isCorrect(CommentedConfig commentedFileConfig) {
        return this.spec.isCorrect((UnmodifiableCommentedConfig)commentedFileConfig);
    }

    public int correct(CommentedConfig commentedFileConfig) {
        this.lock.lock();
        this.spec.correct(commentedFileConfig);
        this.lock.unlock();
        return 0;
    }

    public void afterReload() {
        this.spec.afterReload();
    }
}

