/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks;

import com.mojang.logging.LogUtils;
import com.spydnel.backpacks.networking.BackpackOpenPayload;
import com.spydnel.backpacks.networking.BackpackPayloadHandler;
import com.spydnel.backpacks.registry.BPBlockEntities;
import com.spydnel.backpacks.registry.BPBlocks;
import com.spydnel.backpacks.registry.BPDataAttatchments;
import com.spydnel.backpacks.registry.BPItems;
import com.spydnel.backpacks.registry.BPSounds;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="backpacks")
public class Backpacks {
    public static final String MODID = "backpacks";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Backpacks(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.register(Backpacks.class);
        BPDataAttatchments.ATTACHMENT_TYPES.register(modEventBus);
        BPBlocks.BLOCKS.register(modEventBus);
        BPItems.ITEMS.register(modEventBus);
        BPBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        BPSounds.SOUND_EVENTS.register(modEventBus);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(BackpackOpenPayload.TYPE, BackpackOpenPayload.STREAM_CODEC, BackpackPayloadHandler::HandleClientData);
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex == 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), new ItemLike[]{(ItemLike)BPItems.BACKPACK.value()});
    }

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(BPItems.BACKPACK);
        }
    }
}

