/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.blocks;

import com.spydnel.backpacks.registry.BPBlockEntities;
import com.spydnel.backpacks.registry.BPSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class BackpackBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    public int openTicks;
    public boolean newlyPlaced = true;
    public int placeTicks;
    public int floatTicks;
    public boolean open;
    private int openCount;
    private int color;

    public BackpackBlockEntity(BlockPos pos, BlockState blockState) {
        super(BPBlockEntities.BACKPACK.get(), pos, blockState);
    }

    public int getColor() {
        return this.color;
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            if (this.openCount == 0) {
                this.openTicks = 10;
            }
            if (this.openCount == 1) {
                this.openTicks = 0;
            }
            this.open = this.openCount > 0;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BackpackBlockEntity blockEntity) {
        if (blockEntity.open && blockEntity.openTicks < 10) {
            ++blockEntity.openTicks;
        }
        if (!blockEntity.open && blockEntity.openTicks > 0) {
            --blockEntity.openTicks;
        }
        if (blockEntity.newlyPlaced && blockEntity.placeTicks < 20) {
            ++blockEntity.placeTicks;
        }
        if (blockEntity.placeTicks == 20) {
            blockEntity.newlyPlaced = false;
        }
        if (blockEntity.floatTicks < 90) {
            ++blockEntity.floatTicks;
        }
        if (blockEntity.floatTicks == 90) {
            blockEntity.floatTicks = 0;
        }
    }

    public void onOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)BPSounds.BACKPACK_OPEN.value(), SoundSource.BLOCKS);
            }
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            --this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)BPSounds.BACKPACK_CLOSE.value(), SoundSource.BLOCKS);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.backpack");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.itemStacks = items;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new ShulkerBoxMenu(id, player, (Container)this);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadFromTag(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.itemStacks, (boolean)false, (HolderLookup.Provider)registries);
        }
        tag.putInt("FloatTicks", this.floatTicks);
        tag.putBoolean("NewlyPlaced", this.newlyPlaced);
        tag.putInt("Color", this.color);
        this.setChanged();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        DyedItemColor dyedItemColor = (DyedItemColor)componentInput.get(DataComponents.DYED_COLOR);
        this.color = dyedItemColor != null ? dyedItemColor.rgb() : 0;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.color != 0) {
            components.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(this.color, true));
        }
    }

    public void loadFromTag(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag) && tag.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)levelRegistry);
        }
        this.floatTicks = tag.getInt("FloatTicks");
        this.newlyPlaced = tag.getBoolean("NewlyPlaced");
        this.color = tag.getInt("Color");
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }
}

