/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.events;

import com.spydnel.backpacks.blocks.BackpackBlock;
import com.spydnel.backpacks.blocks.BackpackBlockEntity;
import com.spydnel.backpacks.registry.BPBlocks;
import com.spydnel.backpacks.registry.BPItems;
import com.spydnel.backpacks.registry.BPSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="backpacks")
public class BackpackPickupEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isUnobstructed;
        Level level = event.getLevel();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockPos pos = event.getPos();
        Block block = level.getBlockState(pos).getBlock();
        Object blockEntity = level.getBlockEntity(pos);
        ItemStack heldItem = event.getItemStack();
        ItemStack chestSlotItem = player.getItemBySlot(EquipmentSlot.CHEST);
        boolean hasBackpack = chestSlotItem.is(BPItems.BACKPACK);
        boolean hasChestPlate = !chestSlotItem.isEmpty();
        boolean isAbove = (double)pos.above().getY() > player.getEyeY();
        boolean bl = isUnobstructed = level.isUnobstructed(((BackpackBlock)((Object)BPBlocks.BACKPACK.get())).defaultBlockState(), pos.above(), CollisionContext.of((Entity)player)) && level.getBlockState(pos.above()).canBeReplaced();
        if (player.isShiftKeyDown() && !hasChestPlate && block == BPBlocks.BACKPACK.get() && blockEntity != null) {
            player.swing(hand);
            ItemStack itemstack = new ItemStack(BPBlocks.BACKPACK);
            itemstack.applyComponents(blockEntity.collectComponents());
            player.setItemSlot(EquipmentSlot.CHEST, itemstack);
            BackpackPickupEvents.addParticles(level, pos);
            if (!level.isClientSide) {
                level.removeBlockEntity(pos);
                level.removeBlock(pos, false);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (player.isShiftKeyDown() && heldItem.isEmpty() && hasBackpack && event.getFace() == Direction.UP && !isAbove && isUnobstructed) {
            player.swing(hand);
            player.swingingArm = InteractionHand.MAIN_HAND;
            BlockState state = (BlockState)((BlockState)((BackpackBlock)((Object)BPBlocks.BACKPACK.get())).defaultBlockState().setValue((Property)BackpackBlock.FACING, (Comparable)player.getDirection())).setValue((Property)BackpackBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above()).getType() == Fluids.WATER));
            blockEntity = new BackpackBlockEntity(pos.above(), state);
            blockEntity.applyComponentsFromItemStack(chestSlotItem);
            if (!level.isClientSide) {
                level.setBlockAndUpdate(pos.above(), state);
                level.setBlockEntity(blockEntity);
                chestSlotItem.shrink(1);
                level.playSound(null, pos.above(), (SoundEvent)BPSounds.BACKPACK_PLACE.value(), SoundSource.BLOCKS);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Item item = event.getItemStack().getItem();
        EquipmentSlot slot = null;
        if (item instanceof ArmorItem) {
            slot = ((ArmorItem)item).getEquipmentSlot();
        }
        if (item instanceof Equipable) {
            slot = ((Equipable)item).getEquipmentSlot();
        }
        if (slot == EquipmentSlot.CHEST && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).is(BPItems.BACKPACK)) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemEntityPickup(ItemEntityPickupEvent.Pre event) {
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack itemStack = itemEntity.getItem();
        boolean hasContainer = itemStack.has(DataComponents.CONTAINER);
        boolean isEmpty = Objects.equals(itemStack.get(DataComponents.CONTAINER), ItemContainerContents.EMPTY);
        if (itemStack.is(BPItems.BACKPACK) && hasContainer && !isEmpty) {
            Player player = event.getPlayer();
            if (player.getItemBySlot(EquipmentSlot.CHEST).isEmpty() && !itemEntity.hasPickUpDelay()) {
                player.setItemSlot(EquipmentSlot.CHEST, itemStack);
                player.take((Entity)itemEntity, 1);
                itemEntity.discard();
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)itemStack.getItem()), 1);
                player.onItemPickup(itemEntity);
            }
            event.setCanPickup(TriState.FALSE);
        }
    }

    private static void addParticles(Level level, BlockPos pos) {
        for (int i = 0; i < 4; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.DUST_PLUME, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }
}

