/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.items;

import com.spydnel.backpacks.networking.BackpackOpenPayload;
import com.spydnel.backpacks.registry.BPItems;
import com.spydnel.backpacks.registry.BPSounds;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BackpackItemContainer
extends SimpleContainer {
    LivingEntity target;
    Player player;
    ItemStack itemStack;
    Level level;

    public BackpackItemContainer(LivingEntity target, Player player) {
        super(27);
        this.target = target;
        this.player = player;
        this.itemStack = target.getItemBySlot(EquipmentSlot.CHEST);
        this.level = target.level();
    }

    public boolean stillValid(Player player) {
        return this.target != null && this.itemStack.is(BPItems.BACKPACK) && this.itemStack.has(DataComponents.CONTAINER) && player.distanceTo((Entity)this.target) < 5.0f;
    }

    public void setChanged() {
        this.target.getItemBySlot(EquipmentSlot.CHEST).set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.getItems()));
        super.setChanged();
    }

    public void startOpen(Player player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.target, (CustomPacketPayload)new BackpackOpenPayload(true, this.target.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.target.level().playSound(null, this.target.blockPosition(), (SoundEvent)BPSounds.BACKPACK_OPEN.value(), SoundSource.PLAYERS);
        super.startOpen(player);
    }

    public void stopOpen(Player player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.target, (CustomPacketPayload)new BackpackOpenPayload(false, this.target.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.target.level().playSound(null, this.target.blockPosition(), (SoundEvent)BPSounds.BACKPACK_CLOSE.value(), SoundSource.PLAYERS);
        super.stopOpen(player);
    }
}

