/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.mixins;

import com.spydnel.backpacks.blocks.BackpackBlock;
import com.spydnel.backpacks.blocks.BackpackBlockEntity;
import com.spydnel.backpacks.registry.BPBlocks;
import com.spydnel.backpacks.registry.BPItems;
import com.spydnel.backpacks.registry.BPSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements TraceableEntity {
    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        ItemStack itemStack = ((ItemEntity)this).getItem();
        boolean hasContainer = itemStack.has(DataComponents.CONTAINER);
        boolean isEmpty = Objects.equals(itemStack.get(DataComponents.CONTAINER), ItemContainerContents.EMPTY);
        if (itemStack.is(BPItems.BACKPACK) && hasContainer && !isEmpty) {
            BlockPos pos;
            Level level;
            boolean isUnobstructed;
            if (((ItemEntity)this).getAge() > 0) {
                ((ItemEntity)this).setExtendedLifetime();
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 1.0, 0.9));
            if (this.isInFluidType()) {
                this.getDeltaMovement().add(0.0, 20.0, 0.0);
            }
            boolean bl = isUnobstructed = (level = this.level()).getBlockState((pos = this.getOnPos()).above()).canBeReplaced() && (!level.getFluidState(pos.above()).isSource() || !level.getBlockState(pos.above(2)).canBeReplaced());
            if ((!level.getBlockState(pos).is(BlockTags.REPLACEABLE) || level.getFluidState(pos).isSource()) && isUnobstructed) {
                BlockState state = (BlockState)((BlockState)((BlockState)((BackpackBlock)((Object)BPBlocks.BACKPACK.get())).defaultBlockState().setValue((Property)BackpackBlock.FACING, (Comparable)this.getDirection())).setValue((Property)BackpackBlock.FLOATING, (Comparable)Boolean.valueOf(level.getFluidState(pos).isSource() && !level.getFluidState(pos.above()).isSource()))).setValue((Property)BackpackBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above()).getType() == Fluids.WATER));
                BackpackBlockEntity blockEntity = new BackpackBlockEntity(pos.above(), state);
                blockEntity.applyComponentsFromItemStack(itemStack);
                if (!level.isClientSide) {
                    level.setBlockAndUpdate(pos.above(), state);
                    level.setBlockEntity((BlockEntity)blockEntity);
                    level.playSound(null, pos.above(), (SoundEvent)BPSounds.BACKPACK_PLACE.value(), SoundSource.BLOCKS);
                }
                this.discard();
            }
        }
    }
}

