/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.spydnel.backpacks.blocks.BackpackBlock;
import com.spydnel.backpacks.blocks.BackpackBlockEntity;
import com.spydnel.backpacks.registry.BPLayers;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class BackpackBlockRenderer
implements BlockEntityRenderer<BackpackBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"textures/entity/backpack.png");
    private static final ResourceLocation OVERLAY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"textures/entity/backpack_overlay.png");
    private static final ResourceLocation BASE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"textures/entity/backpack_base.png");
    private final ModelPart base;
    private final ModelPart lid;

    public BackpackBlockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(BPLayers.BACKPACK_BLOCK);
        this.base = modelPart.getChild("base");
        this.lid = this.base.getChild("lid");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -11.0f, -4.0f, 10.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition lid = base.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 19).addBox(-5.5f, -2.0f, -0.5f, 11.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(-9, 33).addBox(-5.5f, 1.0f, -0.5f, 11.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(BackpackBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float t;
        poseStack.pushPose();
        boolean isFloating = (Boolean)blockEntity.getBlockState().getValue((Property)BackpackBlock.FLOATING);
        float dir = ((Direction)blockEntity.getBlockState().getValue((Property)BackpackBlock.FACING)).toYRot();
        float lidRot = 0.0f;
        float baseRotX = 0.0f;
        float baseRotZ = 0.0f;
        float basePosY = 24.0f;
        float baseScaleY = 0.0f;
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-dir));
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.translate(0.0f, isFloating ? -0.8f : -1.0f, 0.0f);
        if (blockEntity.open && blockEntity.openTicks < 10) {
            t = (float)blockEntity.openTicks + partialTick;
            lidRot = (float)Math.pow(2.0, -1.0f * t) * Mth.sin((float)((t - 0.75f) * 0.7f)) + 1.0f;
        } else if (blockEntity.openTicks == 10) {
            lidRot = 1.0f;
        } else if (blockEntity.openTicks > 0) {
            t = (float)blockEntity.openTicks - partialTick;
            lidRot = (float)(-Math.pow(2.0, t - 10.0f)) * Mth.sin((float)((t - 10.75f) * 0.7f));
        }
        if (blockEntity.placeTicks <= 3 && blockEntity.newlyPlaced) {
            t = ((float)blockEntity.placeTicks + partialTick) / 4.0f;
            basePosY = t * t * 4.0f + 20.0f;
        }
        if (blockEntity.placeTicks <= 7 && blockEntity.newlyPlaced) {
            t = ((float)blockEntity.placeTicks + partialTick) / 8.0f;
            baseRotX = Mth.sin((float)(t * 10.0f)) * 0.1f * (1.0f - t);
            baseRotZ = Mth.cos((float)(t * 10.0f)) * 0.1f * (1.0f - t);
        }
        if (isFloating) {
            t = (float)blockEntity.floatTicks + partialTick;
            basePosY += Mth.sin((float)((t + 20.0f) * ((float)Math.PI / 180) * 4.0f)) * 0.75f;
            baseRotX += Mth.sin((float)(t * ((float)Math.PI / 180) * 4.0f)) * 0.02f;
            baseRotZ += Mth.cos((float)(t * ((float)Math.PI / 180) * 4.0f)) * 0.02f;
        }
        this.lid.xRot = lidRot * 1.5f;
        this.base.xRot = baseRotX;
        this.base.zRot = baseRotZ;
        this.base.y = basePosY;
        this.renderBaseLayer(blockEntity, poseStack, buffer, packedLight, packedOverlay);
        if (blockEntity.getColor() != 0) {
            this.renderColoredLayer(blockEntity, poseStack, buffer, packedLight, packedOverlay);
        }
        poseStack.popPose();
    }

    private void renderBaseLayer(BackpackBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ResourceLocation location = blockEntity.getColor() == 0 ? TEXTURE : BASE_TEXTURE;
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)location));
        this.base.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    private void renderColoredLayer(BackpackBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int i = FastColor.ARGB32.opaque((int)blockEntity.getColor());
        if (FastColor.ARGB32.alpha((int)i) == 0) {
            return;
        }
        ResourceLocation location = OVERLAY_TEXTURE;
        if (ModList.get().isLoaded("iris")) {
            this.irisCompatStuff(location);
        }
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)OVERLAY_TEXTURE));
        this.base.render(poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.opaque((int)i));
    }

    private void irisCompatStuff(ResourceLocation location) {
        if (WorldRenderingSettings.INSTANCE.getItemIds() != null) {
            CapturedRenderingState.INSTANCE.setCurrentRenderedItem(WorldRenderingSettings.INSTANCE.getItemIds().applyAsInt((Object)new NamespacedId(location.getNamespace(), location.getPath())));
        }
    }
}

