/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.spydnel.backpacks.Backpacks;
import com.spydnel.backpacks.registry.BPDataAttatchments;
import com.spydnel.backpacks.registry.BPItems;
import com.spydnel.backpacks.registry.BPLayers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.model.ParentType;

@OnlyIn(value=Dist.CLIENT)
public class BackpackLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ModelPart model;
    private final ModelPart parentBody;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"textures/model/backpack.png");
    private static final ResourceLocation OVERLAY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"textures/model/backpack_overlay.png");

    public BackpackLayer(RenderLayerParent renderer, EntityModelSet entityModelSet) {
        super(renderer);
        this.model = entityModelSet.bakeLayer(BPLayers.BACKPACK);
        this.parentBody = this.getParentBody(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (this.shouldRender(itemStack, livingEntity)) {
            if (ModList.get().isLoaded("figura")) {
                Backpacks.LOGGER.debug("figura is loaded");
                this.figuraCompatStuff(poseStack, buffer, packedLight, livingEntity, partialTicks, itemStack, this);
            } else {
                this.renderBaseLayer(poseStack, buffer, packedLight, livingEntity, partialTicks, itemStack, true);
            }
        }
    }

    private void figuraCompatStuff(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float partialTicks, ItemStack itemStack, BackpackLayer backpackLayer) {
        Avatar avatar = AvatarManager.getAvatar(livingEntity);
        if (avatar != null) {
            boolean shouldRender = avatar.luaRuntime != null && avatar.luaRuntime.vanilla_model.CHESTPLATE.getVisible() != null ? avatar.luaRuntime.vanilla_model.CHESTPLATE.getVisible() : true;
            boolean render = avatar.pivotPartRender(ParentType.ChestplatePivot, stack -> {
                stack.scale(16.0f, 16.0f, 16.0f);
                stack.mulPose(Axis.XP.rotationDegrees(180.0f));
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                this.renderBaseLayer((PoseStack)stack, buffer, packedLight, livingEntity, partialTicks, itemStack, false);
            });
            if (!render && shouldRender) {
                this.renderBaseLayer(poseStack, buffer, packedLight, livingEntity, partialTicks, itemStack, true);
            }
        } else {
            this.renderBaseLayer(poseStack, buffer, packedLight, livingEntity, partialTicks, itemStack, true);
        }
    }

    private void renderBaseLayer(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float partialTicks, ItemStack itemStack, boolean copyPose) {
        poseStack.pushPose();
        float lidRot = 0.0f;
        boolean isOpen = (Integer)livingEntity.getData(BPDataAttatchments.OPEN_COUNT) > 0;
        int openTicks = (Integer)livingEntity.getData(BPDataAttatchments.OPEN_TICKS);
        if (isOpen && openTicks < 10) {
            t = (float)openTicks + partialTicks;
            lidRot = (float)Math.pow(2.0, -1.0f * t) * Mth.sin((float)((t - 0.75f) * 0.5f)) + 1.0f;
        } else if (openTicks == 10) {
            lidRot = 1.0f;
        } else if (openTicks > 0) {
            t = (float)openTicks - partialTicks;
            lidRot = (float)(-Math.pow(2.0, t - 10.0f)) * Mth.sin((float)((t - 10.75f) * 0.5f));
        }
        this.model.getChild((String)"base").getChild((String)"lid").xRot = lidRot;
        if (copyPose) {
            this.model.copyFrom(this.parentBody);
        }
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)TEXTURE), (boolean)itemStack.hasFoil());
        this.model.render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        this.renderColoredLayer(poseStack, buffer, packedLight, itemStack);
        poseStack.popPose();
    }

    private void renderColoredLayer(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemStack itemStack) {
        int i = DyedItemColor.getOrDefault((ItemStack)itemStack, (int)0);
        if (FastColor.ARGB32.alpha((int)i) == 0) {
            return;
        }
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)OVERLAY_TEXTURE), (boolean)itemStack.hasFoil());
        this.model.render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.opaque((int)i));
    }

    public boolean shouldRender(ItemStack stack, T entity) {
        return stack.getItem() == BPItems.BACKPACK.asItem();
    }

    protected ModelPart getParentBody(RenderLayerParent<T, HumanoidModel<T>> renderer) {
        return ((HumanoidModel)this.getParentModel()).body;
    }
}

