/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private final ModelPart base;
    private final ModelPart lid;

    public BackpackModel(ModelPart root) {
        this.base = root.getChild("base");
        this.lid = this.base.getChild("lid");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(40, 0).addBox(-7.0f, -10.0f, -4.5f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)).texOffs(0, 0).addBox(-7.0f, -9.0f, -1.0f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)10.0f, (float)2.5f));
        PartDefinition lid = base.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 15).addBox(-4.5f, -1.0f, -2.0f, 9.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(32, 18).addBox(-4.5f, 0.0f, -2.0f, 9.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-9.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.base, (Object)this.lid);
    }
}

