/*
 * Decompiled with CFR 0.152.
 */
package com.spydnel.backpacks.registry;

import com.spydnel.backpacks.models.BackpackBlockRenderer;
import com.spydnel.backpacks.models.BackpackLayer;
import com.spydnel.backpacks.models.BackpackModel;
import com.spydnel.backpacks.registry.BPBlockEntities;
import com.spydnel.backpacks.registry.BPItems;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="backpacks", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BPLayers {
    public static final ModelLayerLocation BACKPACK = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"backpack"), "main");
    public static final ModelLayerLocation BACKPACK_BLOCK = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"backpack_block"), "main");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)BPItems.BACKPACK.asItem(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"backpacks", (String)"dyed"), (stack, level, player, seed) -> BPLayers.isDyed(stack)));
    }

    private static float isDyed(ItemStack stack) {
        return stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f;
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK, BackpackModel::createBodyLayer);
        event.registerLayerDefinition(BACKPACK_BLOCK, BackpackBlockRenderer::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(BPBlockEntities.BACKPACK.get(), BackpackBlockRenderer::new);
    }

    @SubscribeEvent
    public static void addPlayerLayers(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model skin : event.getSkins()) {
            EntityRenderer entityRenderer = event.getSkin(skin);
            if (!(entityRenderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)entityRenderer;
            playerRenderer.addLayer(new BackpackLayer((RenderLayerParent)playerRenderer, event.getEntityModels()));
        }
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        for (EntityType entityType : event.getEntityTypes()) {
            EntityRenderer renderer = event.getRenderer(entityType);
            if (renderer instanceof HumanoidMobRenderer) {
                HumanoidMobRenderer humanoidMobRenderer = (HumanoidMobRenderer)renderer;
                humanoidMobRenderer.addLayer(new BackpackLayer((RenderLayerParent)humanoidMobRenderer, event.getEntityModels()));
                continue;
            }
            if (!(renderer instanceof ArmorStandRenderer)) continue;
            ArmorStandRenderer armorStandRenderer = (ArmorStandRenderer)renderer;
            armorStandRenderer.addLayer(new BackpackLayer((RenderLayerParent)armorStandRenderer, event.getEntityModels()));
        }
    }
}

