/*
 * Decompiled with CFR 0.152.
 */
package crying.tools.interfaces;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CryingManager {
    private static Map<String, CryingManager> managers = new HashMap<String, CryingManager>();
    private static final int FINAL_MAX_INT = 20;
    protected String uuid;
    private float cryingLevel = 0.0f;
    private int cryingTickTimer = 0;
    private int cryingArmorCount = 0;
    private int maxLevel = 0;
    private int permanentMaxLevel = 0;
    private boolean shouldRegen = true;

    public static CryingManager getFromUUID(String uuid) {
        return managers.get(uuid);
    }

    public CryingManager(String uuid) {
        this.uuid = uuid;
        if (managers.containsKey(uuid)) {
            CryingManager manager = CryingManager.getFromUUID(uuid);
            this.permanentMaxLevel = manager.getPermanentMaxLevel();
            this.cryingLevel = manager.getPermanentMaxLevel();
        }
        this.updateThis();
    }

    public void damage(float damage) {
        this.decreaseLevel(damage / 4.0f);
        this.updateThis();
    }

    public void adjustCryingLevel(int armor) {
        if (armor < 0) {
            armor = 0;
        }
        if (armor > 4) {
            armor = 4;
        }
        this.cryingArmorCount = armor;
        this.maxLevel = armor * 5;
        if (this.cryingLevel > (float)this.maxLevel) {
            this.cryingLevel = this.maxLevel;
        } else if (this.cryingLevel < (float)this.getPermanentMaxLevel()) {
            this.cryingLevel = this.getPermanentMaxLevel();
        }
        this.updateThis();
    }

    public void increasePermanentMaxLevel() {
        if (this.getPermanentMaxLevel() >= 20) {
            return;
        }
        this.permanentMaxLevel += 2;
        if (this.getPermanentMaxLevel() >= 20) {
            this.permanentMaxLevel = 20;
        }
        this.updateThis();
    }

    public void update(class_3222 player) {
        class_3218 serverWorld = player.method_51469();
        class_1267 difficulty = serverWorld.method_8407();
        boolean bl = serverWorld.method_64395().method_8355(class_1928.field_19395);
        if (this.getCryingLevel() >= (float)this.getMaxLevel()) {
            this.setRegen(false);
        } else {
            this.setRegen(true);
        }
        if (player.method_7337()) {
            this.setRegen(true);
        }
        if (bl && this.cryingArmorCount > 0 && this.getCryingArmorCount() >= 1 && this.getMaxLevel() > 0 && this.shouldRegen) {
            ++this.cryingTickTimer;
            int ticktime = 300;
            if (difficulty == class_1267.field_5805) {
                ticktime = 100;
            } else if (difficulty == class_1267.field_5807) {
                ticktime = 500;
            }
            if (difficulty == class_1267.field_5801 || player.method_7337()) {
                ticktime = 5;
            }
            if (this.cryingTickTimer >= ticktime) {
                this.decreaseLevel(-1.0f);
                this.cryingTickTimer = 0;
            }
        }
    }

    public void decreaseLevel(float decrease) {
        this.cryingLevel -= decrease;
        if (this.cryingLevel < (float)this.getPermanentMaxLevel()) {
            this.cryingLevel = this.getPermanentMaxLevel();
        } else if (this.cryingLevel > (float)this.maxLevel) {
            this.cryingLevel = this.maxLevel;
        }
        this.updateThis();
    }

    public float getCryingLevel() {
        return this.cryingLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getCryingArmorCount() {
        return this.cryingArmorCount;
    }

    public int getPermanentMaxLevel() {
        return this.permanentMaxLevel;
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10573("cryingLevel", 99)) {
            this.cryingLevel = nbt.method_10583("cryingLevel");
            this.cryingTickTimer = nbt.method_10550("cryingTickTimer");
            this.maxLevel = nbt.method_10550("maxLevel");
            this.permanentMaxLevel = nbt.method_10550("permanentMaxLevel");
            this.cryingArmorCount = nbt.method_10550("cryingArmorCount");
            this.shouldRegen = nbt.method_10577("shouldRegen");
            if (this.cryingLevel > (float)this.maxLevel) {
                this.cryingLevel = this.maxLevel;
            } else if (this.cryingLevel < (float)this.permanentMaxLevel) {
                this.cryingLevel = this.permanentMaxLevel;
            }
            if (this.permanentMaxLevel > 20) {
                this.permanentMaxLevel = 20;
            }
        }
        this.updateThis();
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10548("cryingLevel", this.cryingLevel);
        nbt.method_10569("cryingTickTimer", this.cryingTickTimer);
        nbt.method_10569("permanentMaxLevel", this.permanentMaxLevel);
        nbt.method_10569("maxLevel", this.maxLevel);
        nbt.method_10569("cryingArmorCount", this.cryingArmorCount);
        nbt.method_10556("shouldRegen", this.shouldRegen);
    }

    public void setRegen(boolean regen) {
        if (this.shouldRegen == regen) {
            return;
        }
        this.shouldRegen = regen;
        this.updateThis();
    }

    private void updateThis() {
        managers.put(this.uuid, this);
    }
}

