/*
 * Decompiled with CFR 0.152.
 */
package crying.interfaces;

import crying.Crying;
import crying.enums.CollapsingReason;
import crying.interfaces.BiomeVars;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class SanityManager {
    private static final Map<String, SanityManager> managers = new HashMap<String, SanityManager>();
    protected String uuid;
    public boolean isActive = true;
    private CollapsingReason collapsingReason = CollapsingReason.UNKNOWN;
    private float sanityLevel = 0.0f;
    private int sanityTickTimer = 0;
    private int cryingArmorCount = 0;
    private int maxLevel = 0;
    private int ticksHalfHealth = 0;
    private int collapseRegenTicks = 0;
    private int collapseMultiplier = 1;
    private int darkTicks = 0;
    private boolean shouldRegenCommand = true;
    private boolean shouldRegen = true;

    public static SanityManager getFromUUID(String uuid) {
        return managers.get(uuid);
    }

    public SanityManager(String uuid) {
        this.uuid = uuid;
        this.updateThis();
    }

    public void damage(float damage) {
        if (!this.isActive) {
            return;
        }
        this.decreaseLevel(damage / 4.0f);
        this.updateThis();
    }

    public void adjustSanityLevel(int armor) {
        if (!this.isActive) {
            return;
        }
        if (armor < 0) {
            armor = 0;
        }
        if (armor > 4) {
            armor = 4;
        }
        this.cryingArmorCount = armor;
        this.maxLevel = armor * 5;
        if (this.sanityLevel > (float)this.maxLevel) {
            this.sanityLevel = this.maxLevel;
        }
        this.updateThis();
    }

    public void tick(class_3222 player) {
        if (!this.isActive) {
            return;
        }
        class_3218 serverWorld = player.method_51469();
        class_1267 difficulty = serverWorld.method_8407();
        class_1959 biome = (class_1959)serverWorld.method_23753(player.method_24515()).comp_349();
        if (biome != null) {
            if (biome.method_8712() <= 0.3f) {
                int coldTicks = ((BiomeVars)player).getTicksInColdBiome();
                ((BiomeVars)player).setTicksInColdBiome(++coldTicks);
                if (coldTicks >= Crying.tickSecond(360)) {
                    this.collapse(Crying.tickSecond(420), (class_1309)player, CollapsingReason.HYPOTHERMIA);
                    ((BiomeVars)player).setTicksInColdBiome(0);
                }
            } else {
                ((BiomeVars)player).setTicksInColdBiome(0);
            }
        }
        if (this.getCollapseRegenTicks() >= 1 && !player.method_29504()) {
            this.collapseRegenTicks -= 1 * this.collapseMultiplier;
            if (this.collapseRegenTicks < 0) {
                this.collapseRegenTicks = 0;
            }
            this.updateThis();
            if (this.collapseRegenTicks < 1) {
                this.goBackToNormal((class_1309)player);
            }
        }
        boolean bl = serverWorld.method_64395().method_8355(class_1928.field_19395);
        if (this.getSanityLevel() >= (float)this.getMaxLevel()) {
            this.setRegen(false);
        } else {
            this.setRegen(true);
        }
        this.ticksHalfHealth = player.method_6063() > 1.0f && player.method_6032() / player.method_6063() < 0.5f ? ++this.ticksHalfHealth : 0;
        if (this.ticksHalfHealth % 200 == 0 && this.ticksHalfHealth > 0) {
            this.decreaseLevel(1.0f);
        }
        if (serverWorld.method_8314(class_1944.field_9284, player.method_24515()) <= 4 && serverWorld.method_8314(class_1944.field_9282, player.method_24515()) <= 4) {
            ++this.darkTicks;
            if (this.darkTicks == Crying.tickSecond(30)) {
                this.collapse(Crying.tickSecond(480), (class_1309)player, CollapsingReason.LOW_LIGHT);
                this.darkTicks = 0;
            }
        } else {
            this.darkTicks = 0;
        }
        if (bl && this.cryingArmorCount > 0 && this.getCryingArmorCount() >= 1 && this.getMaxLevel() > 0 && this.shouldRegen && this.shouldRegenCommand) {
            ++this.sanityTickTimer;
            int ticktime = Crying.tickSecond(20);
            if (difficulty == class_1267.field_5805) {
                ticktime = Crying.tickSecond(10);
            } else if (difficulty == class_1267.field_5807) {
                ticktime = Crying.tickSecond(30);
            }
            if (difficulty == class_1267.field_5801) {
                ticktime = 5;
            }
            if (this.sanityTickTimer >= ticktime && this.ticksHalfHealth <= 0) {
                this.decreaseLevel(-1.0f);
                this.sanityTickTimer = 0;
            }
        }
    }

    public void decreaseLevel(float decrease) {
        float max;
        if (!this.isActive) {
            return;
        }
        if (decrease < 0.0f && this.getCollapseRegenTicks() > 0) {
            this.updateThis();
            return;
        }
        if (decrease >= (float)this.getMaxLevel() / 2.0f && this.maxLevel >= 10) {
            this.collapse(Crying.tickSecond(300), null, CollapsingReason.HIGH_DAMAGE);
        }
        this.sanityLevel -= decrease;
        if (this.sanityLevel <= 0.0f) {
            this.sanityTickTimer = 0;
            this.sanityLevel = 0.0f;
        }
        if (this.sanityLevel > (max = (float)this.getMaxLevel())) {
            this.sanityLevel = max;
        }
        this.updateThis();
    }

    private void goBackToNormal(class_1309 entity) {
        if (!this.isActive) {
            return;
        }
        this.sanityLevel = 0.0f;
        this.collapseRegenTicks = 0;
        this.collapsingReason = CollapsingReason.UNKNOWN;
        this.setCollapseMultiplier(1);
        this.updateThis();
    }

    public float getSanityLevel() {
        if (!this.isActive) {
            return 0.0f;
        }
        if (this.getCollapseRegenTicks() > 0) {
            return 0.0f;
        }
        return this.sanityLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getCryingArmorCount() {
        if (!this.isActive) {
            return 0;
        }
        return this.cryingArmorCount;
    }

    public int getCollapseRegenTicks() {
        if (!this.isActive) {
            return 0;
        }
        return this.collapseRegenTicks;
    }

    public int getCollapseMultiplier() {
        if (!this.isActive) {
            return 0;
        }
        return this.collapseMultiplier;
    }

    public CollapsingReason getCollapsingReason() {
        if (!this.isActive) {
            return null;
        }
        return this.collapsingReason;
    }

    public int setSanityLevel(int level) {
        if (!this.isActive) {
            return 1;
        }
        try {
            this.sanityLevel = level;
            if (this.sanityLevel > (float)this.maxLevel) {
                this.sanityLevel = this.maxLevel;
            }
            this.updateThis();
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void collapse(int tick, @Nullable class_1309 entity, CollapsingReason reason) {
        if (!this.isActive) {
            return;
        }
        this.sanityLevel = 0.0f;
        this.collapseRegenTicks = tick;
        this.collapsingReason = reason;
        this.updateThis();
        if (entity != null) {
            entity.method_73183().method_54762(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15115, entity.method_5634());
        }
    }

    public int setCollapseTicks(int ticks, CollapsingReason reason, class_1657 player) {
        if (!this.isActive) {
            return 1;
        }
        try {
            this.collapse(ticks, (class_1309)player, reason);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setCollapseMultiplier(int m) {
        if (!this.isActive) {
            return;
        }
        this.collapseMultiplier = this.getCollapseRegenTicks() >= m ? m : 1;
        this.updateThis();
    }

    public void setRegen(boolean regen) {
        if (!this.isActive) {
            return;
        }
        if (this.shouldRegen == regen) {
            return;
        }
        this.shouldRegen = regen;
        this.updateThis();
    }

    public int setRegenCommand(boolean regen) {
        if (!this.isActive) {
            return 1;
        }
        try {
            this.shouldRegenCommand = regen;
            this.updateThis();
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void readNbt(class_11368 nbt) {
        this.isActive = nbt.method_71433("isActive", true);
        this.sanityTickTimer = nbt.method_71424("sanityTickTimer", 0);
        this.maxLevel = nbt.method_71424("maxLevel", 0);
        this.shouldRegen = nbt.method_71433("shouldRegen", false);
        this.shouldRegenCommand = nbt.method_71433("shouldRegenCommand", true);
        this.ticksHalfHealth = nbt.method_71424("ticksHalfHealth", 0);
        this.collapseRegenTicks = nbt.method_71424("collapseRegenTicks", 0);
        this.darkTicks = nbt.method_71424("darkTicks", 0);
        this.collapseMultiplier = nbt.method_71424("collapseMultiplier", 1);
        this.collapsingReason = CollapsingReason.fromString(nbt.method_71428("collapsingReason", null));
        if (this.sanityLevel > (float)this.maxLevel) {
            this.sanityLevel = this.maxLevel;
        }
        this.updateThis();
    }

    public void writeNbt(class_11372 nbt) {
        nbt.method_71472("isActive", this.isActive);
        nbt.method_71472("shouldRegen", this.shouldRegen);
        nbt.method_71472("shouldRegenCommand", this.shouldRegenCommand);
        nbt.method_71469("collapsingReason", this.collapsingReason.getName());
        nbt.method_71464("sanityLevel", this.sanityLevel);
        nbt.method_71465("sanityTickTimer", this.sanityTickTimer);
        nbt.method_71465("maxLevel", this.maxLevel);
        nbt.method_71465("cryingArmorCount", this.cryingArmorCount);
        nbt.method_71465("ticksHalfHealth", this.ticksHalfHealth);
        nbt.method_71465("collapseRegenTicks", this.collapseRegenTicks);
        nbt.method_71465("darkTicks", this.darkTicks);
        nbt.method_71465("collapseMultiplier", this.collapseMultiplier);
    }

    public int clear() {
        if (!this.isActive) {
            return 1;
        }
        try {
            this.collapseMultiplier = 0;
            this.sanityLevel = 0.0f;
            this.collapseRegenTicks = 0;
            this.collapsingReason = CollapsingReason.UNKNOWN;
            this.updateThis();
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void updateThis() {
        managers.put(this.uuid, this);
    }
}

