/*
 * Decompiled with CFR 0.152.
 */
package crying;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import crying.armors.CryingArmor;
import crying.armors.CryingBootsItem;
import crying.armors.CryingChestplateItem;
import crying.armors.CryingChestplateWithElytraItem;
import crying.armors.CryingHelmetItem;
import crying.armors.CryingHorseArmor;
import crying.armors.CryingLeggingsItem;
import crying.backend.CollapsingReasonArgumentType;
import crying.blocks.CriersHeartBlock;
import crying.blocks.CryingBlock;
import crying.blocks.CryingOreBlock;
import crying.blocks.HardCryingObsidianBlock;
import crying.blocks.LostCryingBlock;
import crying.blocks.VoidStainedCryingBlock;
import crying.blocks.core.HardenedCoreBlock;
import crying.blocks.core.OverHardenedCoreBlock;
import crying.blocks.core.OverHardenedCoreWithEyeBlock;
import crying.blocks.food.CryingFoodAppleBlock;
import crying.blocks.food.CryingFoodCarrotBlock;
import crying.blocks.food.CryingFoodEnchantedAppleBlock;
import crying.effects.BaneOfCriers;
import crying.entities.CrierEntity;
import crying.entities.CriersHeartBlockEntity;
import crying.entities.CryingFoodEntity;
import crying.entities.GranterEntity;
import crying.entities.GrapplingHookEntity;
import crying.entities.LostCrierEntity;
import crying.enums.ToolType;
import crying.interfaces.CryingTool;
import crying.interfaces.HookVars;
import crying.interfaces.SanityManager;
import crying.interfaces.SanityVars;
import crying.items.CrierSpawnEggItem;
import crying.items.CryingAppleItem;
import crying.items.CryingCarrotItem;
import crying.items.CryingGrapplingHookItem;
import crying.items.CryingGrapplingHookTipItem;
import crying.items.CryingResidueItem;
import crying.items.EnchantedCryingAppleItem;
import crying.items.EyeConnectedToAStickItem;
import crying.items.EyeItem;
import crying.items.GranterItem;
import crying.items.HardenedCorePieceItem;
import crying.items.LostCrierSpawnEggItem;
import crying.items.ingot.AbstractCryingIngotItem;
import crying.items.ingot.CryingIngotCopperItem;
import crying.items.ingot.CryingIngotDiamondItem;
import crying.items.ingot.CryingIngotGoldItem;
import crying.items.ingot.CryingIngotIronItem;
import crying.items.ingot.CryingIngotItem;
import crying.items.ingot.CryingIngotNetheriteItem;
import crying.other.CryingLoot;
import crying.other.CryingTags;
import crying.tools.CryingShieldItem;
import crying.tools.axe.CryingAxeCopperItem;
import crying.tools.axe.CryingAxeDiamondItem;
import crying.tools.axe.CryingAxeGoldItem;
import crying.tools.axe.CryingAxeIronItem;
import crying.tools.axe.CryingAxeItem;
import crying.tools.axe.CryingAxeNetheriteItem;
import crying.tools.hoe.CryingHoeCopperItem;
import crying.tools.hoe.CryingHoeDiamondItem;
import crying.tools.hoe.CryingHoeGoldItem;
import crying.tools.hoe.CryingHoeIronItem;
import crying.tools.hoe.CryingHoeItem;
import crying.tools.hoe.CryingHoeNetheriteItem;
import crying.tools.pickaxe.CryingPickaxeCopperItem;
import crying.tools.pickaxe.CryingPickaxeDiamondItem;
import crying.tools.pickaxe.CryingPickaxeGoldItem;
import crying.tools.pickaxe.CryingPickaxeIronItem;
import crying.tools.pickaxe.CryingPickaxeItem;
import crying.tools.pickaxe.CryingPickaxeNetheriteItem;
import crying.tools.pickaxe.CryingPickaxeOverHardenedCoreWithEyeItem;
import crying.tools.shovel.CryingShovelCopperItem;
import crying.tools.shovel.CryingShovelDiamondItem;
import crying.tools.shovel.CryingShovelGoldItem;
import crying.tools.shovel.CryingShovelIronItem;
import crying.tools.shovel.CryingShovelItem;
import crying.tools.shovel.CryingShovelNetheriteItem;
import crying.tools.sword.CriersSwordItem;
import crying.tools.sword.CryingSwordCopperItem;
import crying.tools.sword.CryingSwordDiamondItem;
import crying.tools.sword.CryingSwordGoldItem;
import crying.tools.sword.CryingSwordIronItem;
import crying.tools.sword.CryingSwordItem;
import crying.tools.sword.CryingSwordNetheriteItem;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_10394;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2591;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8051;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import net.minecraft.class_9848;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import semantic.ver.lib.SemanticVerLib;
import semantic.ver.lib.SemanticVersion;

public class Crying
implements ModInitializer {
    private static final String VERSION_URL = "https://raw.githubusercontent.com/ThomasDarkson/crying/refs/heads/version/version.txt";
    public static final SemanticVersion VERSION = SemanticVersion.stable((int)6, (int)1, (int)3, (String)"https://raw.githubusercontent.com/ThomasDarkson/crying/refs/heads/version/version.txt");
    public static final String ID = "crying";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"crying");
    public static final int MAX_CRYING_FOOD_COUNT = 9888;
    public static final class_2940<Integer> FOOD_COUNT = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);
    public static final class_1299<CrierEntity> CRIER = (class_1299)class_2378.method_39197((class_2378)class_7923.field_41177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"crier")), (Object)class_1299.class_1300.method_5903(CrierEntity::new, (class_1311)class_1311.field_6302).method_17687(0.58f, 1.98f).method_55687(1.75f).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"crier"))));
    public static final class_1299<LostCrierEntity> LOST_CRIER = (class_1299)class_2378.method_39197((class_2378)class_7923.field_41177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"lost_crier")), (Object)class_1299.class_1300.method_5903(LostCrierEntity::new, (class_1311)class_1311.field_6294).method_17687(0.58f, 1.98f).method_55687(1.75f).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"lost_crier"))));
    public static final class_1299<GrapplingHookEntity> GRAPPLING_HOOK = (class_1299)class_2378.method_39197((class_2378)class_7923.field_41177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"grappling_hook_entity")), (Object)class_1299.class_1300.method_5903(GrapplingHookEntity::new, (class_1311)class_1311.field_17715).method_17687(0.5f, 0.5f).method_27299(8).method_27300(1).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"grappling_hook_entity"))));
    public static final class_1299<GranterEntity> GRANTER_ENTITY = (class_1299)class_2378.method_39197((class_2378)class_7923.field_41177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"granter")), (Object)class_1299.class_1300.method_5903(GranterEntity::new, (class_1311)class_1311.field_17715).method_17687(0.2f, 0.2f).method_27300(1).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"crying", (String)"granter"))));
    public static final class_2248 CRIERS_HEART = new CriersHeartBlock(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"crying", (String)"criers_heart"))).method_9629(0.0f, 3.6E7f).method_9631(state -> 2));
    public static final class_2591<CriersHeartBlockEntity> CRIERS_HEART_BLOCK_ENTITY = Crying.registerBlockEntityType("criers_heart", FabricBlockEntityTypeBuilder.create(CriersHeartBlockEntity::new, (class_2248[])new class_2248[]{CRIERS_HEART}).build());
    public static final class_2248 CRYING_FOOD_CARROT = new CryingFoodCarrotBlock();
    public static final class_2248 CRYING_FOOD_APPLE = new CryingFoodAppleBlock();
    public static final class_2248 CRYING_FOOD_ENCHANTED_APPLE = new CryingFoodEnchantedAppleBlock();
    public static final class_2591<CryingFoodEntity> CRYING_FOOD_BLOCK_ENTITY = Crying.registerBlockEntityType("crying_food_block_entity", FabricBlockEntityTypeBuilder.create(CryingFoodEntity::new, (class_2248[])new class_2248[]{CRYING_FOOD_CARROT, CRYING_FOOD_APPLE, CRYING_FOOD_ENCHANTED_APPLE}).build());
    public static final class_5321<class_1959> SOMEWHAT_WEIRD_ISLAND = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"crying", (String)"somewhat_weird_island"));
    public static final class_5321<class_1959> SOMEWHAT_NORMAL_ISLAND = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"crying", (String)"somewhat_normal_island"));
    public static final class_5321<class_1937> CRYING_WORLD = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"crying", (String)"crying"));
    public static final class_5321<class_5363> CRYING_DIMENSION = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)class_2960.method_60655((String)"crying", (String)"crying"));
    public static final class_5321<class_2874> CRYING_DIMENSION_TYPE = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)class_2960.method_60655((String)"crying", (String)"crying"));
    public static final class_9331<Boolean> WAS_WAXED;
    public static final class_9331<Integer> OXIDATION_SECONDS;
    public static final class_9331<String> OXIDATION_LEVEL;
    public static final class_9331<Boolean> THROWN;
    public static final class_9331<String> HOOK_UUID;
    public static final class_1792 CRYING_SHIELD;
    public static final class_1792 CRYING_HELMET;
    public static final class_1792 CRYING_CHESTPLATE;
    public static final class_1792 CRYING_CHESTPLATE_WITH_ELYTRA;
    public static final class_1792 CRYING_LEGGINGS;
    public static final class_1792 CRYING_BOOTS;
    public static final class_1792 CRYING_HORSE_ARMOR;
    public static final class_1792 GRANTER;
    public static final class_1792 CRYING_GRAPPLING_HOOK;
    public static final class_1792 CRYING_GRAPPLING_HOOK_TIP;
    public static final class_1792 CRYING_RESIDUE;
    public static final class_1792 CRYING_INGOT;
    public static final class_1792 CRYING_INGOT_NETHERITE;
    public static final class_1792 CRYING_INGOT_DIAMOND;
    public static final class_1792 CRYING_INGOT_IRON;
    public static final class_1792 CRYING_INGOT_COPPER;
    public static final class_1792 CRYING_INGOT_GOLD;
    public static final class_1792 CRYING_APPLE;
    public static final class_1792 CRYING_CARROT;
    public static final class_1792 ENCHANTED_CRYING_APPLE;
    public static final class_1792 CRYING_PICKAXE_OVER_HARDENED_CORE_WITH_EYE;
    public static final class_1792 CRYING_PICKAXE;
    public static final class_1792 CRYING_PICKAXE_NETHERITE;
    public static final class_1792 CRYING_PICKAXE_DIAMOND;
    public static final class_1792 CRYING_PICKAXE_IRON;
    public static final class_1792 CRYING_PICKAXE_COPPER;
    public static final class_1792 CRYING_PICKAXE_GOLD;
    public static final class_1792 CRIERS_SWORD;
    public static final class_1792 CRYING_SWORD;
    public static final class_1792 CRYING_SWORD_NETHERITE;
    public static final class_1792 CRYING_SWORD_DIAMOND;
    public static final class_1792 CRYING_SWORD_IRON;
    public static final class_1792 CRYING_SWORD_COPPER;
    public static final class_1792 CRYING_SWORD_GOLD;
    public static final class_1792 CRYING_AXE;
    public static final class_1792 CRYING_AXE_NETHERITE;
    public static final class_1792 CRYING_AXE_DIAMOND;
    public static final class_1792 CRYING_AXE_IRON;
    public static final class_1792 CRYING_AXE_COPPER;
    public static final class_1792 CRYING_AXE_GOLD;
    public static final class_1792 CRYING_SHOVEL;
    public static final class_1792 CRYING_SHOVEL_NETHERITE;
    public static final class_1792 CRYING_SHOVEL_DIAMOND;
    public static final class_1792 CRYING_SHOVEL_IRON;
    public static final class_1792 CRYING_SHOVEL_COPPER;
    public static final class_1792 CRYING_SHOVEL_GOLD;
    public static final class_1792 CRYING_HOE;
    public static final class_1792 CRYING_HOE_NETHERITE;
    public static final class_1792 CRYING_HOE_DIAMOND;
    public static final class_1792 CRYING_HOE_IRON;
    public static final class_1792 CRYING_HOE_COPPER;
    public static final class_1792 CRYING_HOE_GOLD;
    public static final class_1792 EYE;
    public static final class_1792 EYE_CONNECTED_TO_A_STICK;
    public static final class_1792 HARDENED_CORE_PIECE;
    public static final class_2248 HARDENED_CORE;
    public static final class_2248 OVER_HARDENED_CORE;
    public static final class_2248 OVER_HARDENED_CORE_WITH_EYE;
    public static final class_2248 HARD_CRYING_OBSIDIAN;
    public static final class_2248 CRYING_BLOCK;
    public static final class_2248 CRYING_ORE;
    public static final class_2248 VOID_STAINED_CRYING_BLOCK;
    public static final class_2248 LOST_CRYING_BLOCK;
    public static final class_1792 CRIER_SPAWN_EGG;
    public static final class_1792 LOST_CRIER_SPAWN_EGG;
    public static final class_2960 CRIER_IDLE;
    public static final class_3414 CRIER_IDLE_EVENT;
    public static final class_2960 CRIER_HURT;
    public static final class_3414 CRIER_HURT_EVENT;
    public static final class_2960 CRIER_DIES;
    public static final class_3414 CRIER_DIES_EVENT;
    public static final class_2960 CRIER_SCREAM;
    public static final class_3414 CRIER_SCREAM_EVENT;
    public static final class_2960 GRANTER_HEAL;
    public static final class_3414 GRANTER_HEAL_EVENT;
    public static final class_6880.class_6883<class_3414> LIVING_MICE;
    public static final class_6880.class_6883<class_3414> CRYING_MICE;

    public void onInitialize() {
        SemanticVerLib.initialize();
        VERSION.checkForUpdates(null);
        BaneOfCriers.initialize();
        crying.enchantments.BaneOfCriers.initialize();
        CryingLoot.modifyLootTables();
        CryingTags.initialize();
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CRIER_IDLE, (Object)CRIER_IDLE_EVENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CRIER_HURT, (Object)CRIER_HURT_EVENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CRIER_DIES, (Object)CRIER_DIES_EVENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)GRANTER_HEAL, (Object)GRANTER_HEAL_EVENT);
        FabricDefaultAttributeRegistry.register(CRIER, (class_5132.class_5133)CrierEntity.createCrierAttributes());
        FabricDefaultAttributeRegistry.register(LOST_CRIER, (class_5132.class_5133)LostCrierEntity.createLostCrierAttributes());
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)ID, (String)"collapsing_reason"), CollapsingReasonArgumentType.class, (class_2314)class_2319.method_41999(CollapsingReasonArgumentType::collapsingReason));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)ID).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Crying Tools ").method_27693(VERSION.toString()), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"crying.thank.you"), false);
            return 0;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sanity").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"deactivate").executes(context -> {
            SanityManager manager = Crying.getSanityManager((class_1657)((class_2168)context.getSource()).method_44023());
            manager.isActive = false;
            manager.updateThis();
            return 0;
        }))).then(class_2170.method_9247((String)"activate").executes(context -> {
            SanityManager manager = Crying.getSanityManager((class_1657)((class_2168)context.getSource()).method_44023());
            manager.isActive = true;
            manager.updateThis();
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"sanityLevel").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> {
            SanityManager manager = Crying.getSanityManager((class_1657)((class_2168)context.getSource()).method_44023());
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            return manager.setSanityLevel(level);
        })))).then(class_2170.method_9247((String)"shouldRegen").then(class_2170.method_9244((String)"regen", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            SanityManager manager = Crying.getSanityManager((class_1657)((class_2168)context.getSource()).method_44023());
            return manager.setRegenCommand(BoolArgumentType.getBool((CommandContext)context, (String)"regen"));
        }))))).then(class_2170.method_9247((String)"clear").executes(context -> {
            SanityManager manager = Crying.getSanityManager((class_1657)((class_2168)context.getSource()).method_44023());
            return manager.clear();
        }))).then(class_2170.method_9247((String)"collapse").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"reason", (ArgumentType)CollapsingReasonArgumentType.collapsingReason()).executes(context -> {
            SanityManager manager = Crying.getSanityManager((class_1657)((class_2168)context.getSource()).method_44023());
            return manager.setCollapseTicks(IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), CollapsingReasonArgumentType.getReason(context, "reason"), (class_1657)((class_2168)context.getSource()).method_44023());
        })))))));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            try {
                server.method_3760().method_14571().forEach(player -> {
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = player;
                        CryingArmor.setCount((class_1309)serverPlayer);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        EntityElytraEvents.CUSTOM.register((entity, tick) -> {
            try {
                class_1799 mainStack = entity.method_6118(class_1304.field_6174);
                return mainStack.method_7909() instanceof CryingChestplateWithElytraItem;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    public static final class_1792 register(class_1792 item, String id) {
        class_2960 itemID = class_2960.method_60655((String)ID, (String)id);
        class_1792 registeredItem = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)itemID, (Object)item);
        return registeredItem;
    }

    public static class_2248 registerBlock(class_2248 block, String name) {
        class_2960 id = class_2960.method_60655((String)ID, (String)name);
        class_1814 rarity = class_1814.field_8906;
        Integer stack = 64;
        class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)ID, (String)name)));
        if (name == "over-hardened_core" || name == "over-hardened_core_with_eye" || name == "criers_heart") {
            stack = 1;
            rarity = class_1814.field_8904;
            settings = settings.method_24359();
        }
        if (name == "void-stained_crying_block") {
            rarity = class_1814.field_8904;
            stack = 1;
        }
        if (name == "hardened_core") {
            rarity = class_1814.field_8903;
            stack = 1;
        }
        settings = settings.method_7894(rarity);
        settings = settings.method_7889(stack.intValue());
        class_1747 blockItem = new class_1747(block, settings);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)blockItem);
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
    }

    public static <T extends class_2591<?>> T registerBlockEntityType(String path, T blockEntityType) {
        return (T)((class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)class_2960.method_60655((String)ID, (String)path), blockEntityType));
    }

    public static class_1741 registerMaterial(int durability, Map<class_8051, Integer> defensePoints, int enchantability, class_6880<class_3414> equipSound, float toughness, float knockbackResistance, class_6862<class_1792> tagKey, class_5321<class_10394> registr) {
        class_1741 material = new class_1741(durability, defensePoints, enchantability, equipSound, toughness, knockbackResistance, tagKey, registr);
        return material;
    }

    public static class_1268 getHandThatHasCryingShield(class_1657 entity) {
        class_1268[] hands;
        for (class_1268 hand : hands = new class_1268[]{class_1268.field_5808, class_1268.field_5810}) {
            class_1799 stack = entity.method_5998(hand);
            if (stack == null || !(stack.method_7909() instanceof CryingShieldItem)) continue;
            return hand;
        }
        return null;
    }

    public static class_1792 getCoreIngredient(class_1799 stack) {
        class_1792 class_17922;
        if (stack.method_7960()) {
            LOGGER.info("crying: EMPTY STACK ERROR");
        }
        if ((class_17922 = stack.method_7909()) instanceof CryingTool) {
            CryingTool tool = (CryingTool)class_17922;
            return tool.getCoreIngredient();
        }
        return CRYING_INGOT;
    }

    public static boolean isTheCriersSword(class_1799 stack) {
        CryingTool tool;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof CryingTool && (tool = (CryingTool)class_17922).getToolType() == ToolType.SWORD && Crying.getCoreIngredient(stack) == OVER_HARDENED_CORE_WITH_EYE.method_8389();
    }

    public static boolean isTheCryingBeing(class_1799 stack) {
        CryingTool tool;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof CryingTool && (tool = (CryingTool)class_17922).getToolType() == ToolType.PICKAXE && Crying.getCoreIngredient(stack) == OVER_HARDENED_CORE_WITH_EYE.method_8389();
    }

    public static class_5250 getCoreIngredientText(class_1799 stack) {
        class_1792 item = Crying.getCoreIngredient(stack);
        if (item == class_1802.field_8620) {
            return class_2561.method_43471((String)"core.ingredient.iron").method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
        }
        if (item == class_1802.field_8477) {
            return class_2561.method_43471((String)"core.ingredient.diamond").method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
        }
        if (item == class_1802.field_22020) {
            return class_2561.method_43471((String)"core.ingredient.netherite").method_10862(class_2583.field_24360.method_10977(class_124.field_1063));
        }
        if (item == class_1802.field_8695) {
            return class_2561.method_43471((String)"core.ingredient.gold").method_10862(class_2583.field_24360.method_10977(class_124.field_1054));
        }
        if (item == class_1802.field_27022) {
            return class_2561.method_43471((String)"core.ingredient.copper").method_10862(class_2583.field_24360.method_36139(class_9848.method_61324((int)255, (int)255, (int)128, (int)0)));
        }
        if (item == OVER_HARDENED_CORE_WITH_EYE.method_8389()) {
            return class_2561.method_43471((String)"item.crying.over-hardened_core_with_eye").method_10862(class_2583.field_24360.method_36139(1966200));
        }
        return class_2561.method_43471((String)"core.ingredient.crying").method_10862(class_2583.field_24360.method_10977(class_124.field_1064));
    }

    public static class_5250 getInfusionItemText(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof AbstractCryingIngotItem) {
            AbstractCryingIngotItem ingot = (AbstractCryingIngotItem)class_17922;
            class_1792 item = ingot.getInfusedItem();
            if (item == class_1802.field_8620) {
                return class_2561.method_43471((String)"core.ingredient.iron").method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
            }
            if (item == class_1802.field_8477) {
                return class_2561.method_43471((String)"core.ingredient.diamond").method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
            }
            if (item == class_1802.field_22020) {
                return class_2561.method_43471((String)"core.ingredient.netherite").method_10862(class_2583.field_24360.method_10977(class_124.field_1063));
            }
            if (item == class_1802.field_8695) {
                return class_2561.method_43471((String)"core.ingredient.gold").method_10862(class_2583.field_24360.method_10977(class_124.field_1054));
            }
            if (item == class_1802.field_27022) {
                return class_2561.method_43471((String)"core.ingredient.copper").method_10862(class_2583.field_24360.method_36139(class_9848.method_61324((int)255, (int)255, (int)128, (int)0)));
            }
            return class_2561.method_43471((String)"core.ingredient.nothing");
        }
        return null;
    }

    public static int nextBetweenInt(int min, int max) {
        Random random = new Random();
        int f = random.nextInt(max - min + 1) + min;
        return f;
    }

    public static float nextBetween(float min, float max) {
        Random random = new Random();
        float f = random.nextFloat(max - min + 1.0f) + min;
        return f;
    }

    public static float floorDecimal(float value, int decimals) {
        if (decimals < 1) {
            return (float)Math.floor(value);
        }
        float mult = 0.0f;
        for (int m = 0; m < decimals; ++m) {
            mult += 10.0f;
        }
        float newValue = (float)Math.floor(value * mult);
        return newValue / mult;
    }

    public static int tickSecond(int second) {
        return Math.abs(second * 20);
    }

    public static String tickToString(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static SanityManager getSanityManager(class_1657 player) {
        return ((SanityVars)player).getManager();
    }

    public static HookVars getHook(class_1657 player) {
        return (HookVars)player;
    }

    static {
        CRIER_IDLE = class_2960.method_60655((String)ID, (String)"crier_idle");
        CRIER_IDLE_EVENT = class_3414.method_47908((class_2960)CRIER_IDLE);
        CRIER_HURT = class_2960.method_60655((String)ID, (String)"crier_hurt");
        CRIER_HURT_EVENT = class_3414.method_47908((class_2960)CRIER_HURT);
        CRIER_DIES = class_2960.method_60655((String)ID, (String)"crier_dies");
        CRIER_DIES_EVENT = class_3414.method_47908((class_2960)CRIER_DIES);
        CRIER_SCREAM = class_2960.method_60655((String)ID, (String)"crier_scream");
        CRIER_SCREAM_EVENT = class_3414.method_47908((class_2960)CRIER_SCREAM);
        GRANTER_HEAL = class_2960.method_60655((String)ID, (String)"granter_heal");
        GRANTER_HEAL_EVENT = class_3414.method_47908((class_2960)GRANTER_HEAL);
        LIVING_MICE = class_2378.method_47985((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)ID, (String)"living_mice_crying_biome"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)ID, (String)"living_mice_crying_biome")));
        CRYING_MICE = class_2378.method_47985((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)ID, (String)"crying_mice"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)ID, (String)"crying_mice")));
        WAS_WAXED = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)ID, (String)"was_waxed"), (Object)class_9331.method_57873().method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547).method_57880());
        OXIDATION_SECONDS = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)ID, (String)"oxidation_seconds"), (Object)class_9331.method_57873().method_57881(Codec.intRange((int)0, (int)Integer.MAX_VALUE)).method_57880());
        OXIDATION_LEVEL = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)ID, (String)"oxidation_level"), (Object)class_9331.method_57873().method_57881(Codec.string((int)0, (int)Integer.MAX_VALUE)).method_57880());
        THROWN = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)ID, (String)"hook_thrown"), (Object)class_9331.method_57873().method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547).method_57880());
        HOOK_UUID = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)ID, (String)"hook_uuid"), (Object)class_9331.method_57873().method_57881(Codec.string((int)0, (int)Integer.MAX_VALUE)).method_57880());
        CRYING_BLOCK = new CryingBlock();
        HARD_CRYING_OBSIDIAN = new HardCryingObsidianBlock();
        CRYING_ORE = new CryingOreBlock();
        OVER_HARDENED_CORE = new OverHardenedCoreBlock();
        OVER_HARDENED_CORE_WITH_EYE = new OverHardenedCoreWithEyeBlock();
        VOID_STAINED_CRYING_BLOCK = new VoidStainedCryingBlock();
        LOST_CRYING_BLOCK = new LostCryingBlock();
        HARDENED_CORE_PIECE = new HardenedCorePieceItem();
        HARDENED_CORE = new HardenedCoreBlock();
        CRYING_RESIDUE = new CryingResidueItem();
        CRYING_INGOT = new CryingIngotItem();
        CRYING_INGOT_NETHERITE = new CryingIngotNetheriteItem();
        CRYING_INGOT_DIAMOND = new CryingIngotDiamondItem();
        CRYING_INGOT_IRON = new CryingIngotIronItem();
        CRYING_INGOT_COPPER = new CryingIngotCopperItem();
        CRYING_INGOT_GOLD = new CryingIngotGoldItem();
        CRYING_APPLE = new CryingAppleItem();
        CRYING_CARROT = new CryingCarrotItem();
        ENCHANTED_CRYING_APPLE = new EnchantedCryingAppleItem();
        EYE = new EyeItem();
        EYE_CONNECTED_TO_A_STICK = new EyeConnectedToAStickItem();
        CRIER_SPAWN_EGG = new CrierSpawnEggItem();
        LOST_CRIER_SPAWN_EGG = new LostCrierSpawnEggItem();
        GRANTER = new GranterItem();
        CRYING_GRAPPLING_HOOK = new CryingGrapplingHookItem();
        CRYING_GRAPPLING_HOOK_TIP = new CryingGrapplingHookTipItem();
        CRYING_PICKAXE_OVER_HARDENED_CORE_WITH_EYE = new CryingPickaxeOverHardenedCoreWithEyeItem();
        CRYING_PICKAXE = new CryingPickaxeItem();
        CRYING_PICKAXE_NETHERITE = new CryingPickaxeNetheriteItem();
        CRYING_PICKAXE_DIAMOND = new CryingPickaxeDiamondItem();
        CRYING_PICKAXE_IRON = new CryingPickaxeIronItem();
        CRYING_PICKAXE_COPPER = new CryingPickaxeCopperItem();
        CRYING_PICKAXE_GOLD = new CryingPickaxeGoldItem();
        CRIERS_SWORD = new CriersSwordItem();
        CRYING_SWORD = new CryingSwordItem();
        CRYING_SWORD_NETHERITE = new CryingSwordNetheriteItem();
        CRYING_SWORD_DIAMOND = new CryingSwordDiamondItem();
        CRYING_SWORD_IRON = new CryingSwordIronItem();
        CRYING_SWORD_COPPER = new CryingSwordCopperItem();
        CRYING_SWORD_GOLD = new CryingSwordGoldItem();
        CRYING_AXE = new CryingAxeItem();
        CRYING_AXE_NETHERITE = new CryingAxeNetheriteItem();
        CRYING_AXE_DIAMOND = new CryingAxeDiamondItem();
        CRYING_AXE_IRON = new CryingAxeIronItem();
        CRYING_AXE_COPPER = new CryingAxeCopperItem();
        CRYING_AXE_GOLD = new CryingAxeGoldItem();
        CRYING_SHOVEL = new CryingShovelItem();
        CRYING_SHOVEL_NETHERITE = new CryingShovelNetheriteItem();
        CRYING_SHOVEL_DIAMOND = new CryingShovelDiamondItem();
        CRYING_SHOVEL_IRON = new CryingShovelIronItem();
        CRYING_SHOVEL_COPPER = new CryingShovelCopperItem();
        CRYING_SHOVEL_GOLD = new CryingShovelGoldItem();
        CRYING_HOE = new CryingHoeItem();
        CRYING_HOE_NETHERITE = new CryingHoeNetheriteItem();
        CRYING_HOE_DIAMOND = new CryingHoeDiamondItem();
        CRYING_HOE_IRON = new CryingHoeIronItem();
        CRYING_HOE_COPPER = new CryingHoeCopperItem();
        CRYING_HOE_GOLD = new CryingHoeGoldItem();
        CRYING_SHIELD = new CryingShieldItem();
        CRYING_BOOTS = new CryingBootsItem();
        CRYING_LEGGINGS = new CryingLeggingsItem();
        CRYING_CHESTPLATE = new CryingChestplateItem();
        CRYING_CHESTPLATE_WITH_ELYTRA = new CryingChestplateWithElytraItem();
        CRYING_HELMET = new CryingHelmetItem();
        CRYING_HORSE_ARMOR = new CryingHorseArmor();
    }
}

