/*
 * Decompiled with CFR 0.152.
 */
package crying.entities;

import crying.Crying;
import crying.goals.FastBreakDoorGoal;
import crying.interfaces.NbtInterface;
import crying.other.CrierExplosionBehavior;
import java.util.ArrayList;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1395;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1439;
import net.minecraft.class_1451;
import net.minecraft.class_1473;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5425;
import net.minecraft.class_5493;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7260;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class CrierEntity
extends class_1588 {
    class_3213 bossBar = null;
    class_3213 shieldBar = null;
    private static final float shieldMaxHealth = 336.0f;
    private float shieldHealth = 336.0f;
    private static final class_2940<Boolean> secondPhase = class_2945.method_12791(CrierEntity.class, (class_2941)class_2943.field_13323);
    private boolean initializedExplosion = false;
    private boolean isSmall = false;
    private boolean healing = false;
    private int healingTicks = 0;
    private ArrayList<String> gotAttackedByPlayer = new ArrayList();

    public CrierEntity(class_1299<? extends CrierEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_47825(goal -> true);
        this.field_6185.method_35113(target -> true);
        this.field_6207 = new class_1331((class_1308)this, 1, false);
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1473.class, false));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1560.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1451.class, false));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1439.class, false));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_7260.class, false));
        this.field_6201.method_6277(3, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        class_1324 instance = this.method_5996(class_5134.field_47760);
        if (world.method_8409().method_43057() < 0.005f) {
            instance.method_6192(6.0);
        }
        double extra = 0.0;
        if (world.method_18456().size() > 1) {
            extra = 25.0 * (double)(world.method_18456().size() - 1);
        }
        double health = 618.0 + extra;
        this.method_5996(class_5134.field_23716).method_6192(health);
        this.method_6033((float)health);
        this.bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
        this.bossBar.method_14091(true);
        this.bossBar.method_5410(false);
        this.bossBar.method_5408(0.0f);
        this.shieldBar = new class_3213((class_2561)class_2561.method_43471((String)"bar.shield.health"), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
        this.shieldBar.method_14091(true);
        this.shieldBar.method_5410(false);
        this.shieldBar.method_5408(0.0f);
        this.method_37222(new class_1293(class_1294.field_5911, -1, 22, false, false, false), (class_1297)this);
        this.setCanBreakDoors(true);
        if (this.method_37908().method_40134().method_40230().get() != class_7134.field_37666) {
            this.method_37908().method_8501(this.method_24515(), class_2246.field_22423.method_9564());
            this.method_37908().method_8406((class_2394)class_2398.field_22447, this.method_23317(), this.method_23317(), this.method_23321(), 1.0, 1.0, 1.0);
            this.method_56078(this.method_6002());
            this.method_31472();
        }
    }

    public static class_5132.class_5133 createCrierAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 37.0).method_26868(class_5134.field_23719, 0.345).method_26868(class_5134.field_23720, 3.4).method_26868(class_5134.field_23727, 0.0).method_26868(class_5134.field_23718, 0.3).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_51578, 1.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(secondPhase, (Object)false);
    }

    public boolean method_6049(class_1293 effect) {
        return effect.method_55654(class_1294.field_5911) && effect.method_5578() == 22;
    }

    protected class_3414 method_5994() {
        return Crying.CRIER_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return Crying.CRIER_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return Crying.CRIER_DIES_EVENT;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5819 r = world.method_8409();
        this.method_5964(r, difficulty);
        this.setCanBreakDoors(true);
        return entityData;
    }

    void addShield() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8255);
        this.method_5673(class_1304.field_6171, stack);
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)Crying.CRYING_HELMET));
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)Crying.CRIERS_SWORD));
        this.addShield();
    }

    protected void method_5958(class_3218 world) {
        class_1309 class_13092;
        super.method_5958(world);
        if (!this.method_24828()) {
            this.method_18380(class_4050.field_18077);
        } else {
            this.method_18380(class_4050.field_18076);
        }
        if (this.method_5968() != null && (class_13092 = this.method_5968()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            this.isSmall = player.method_20232() && !player.method_5869();
            this.changeScale();
        }
        if (!this.initializedExplosion) {
            world.method_8454((class_1297)this, class_1927.method_55108((class_1937)world, (class_1297)this), (class_5362)new CrierExplosionBehavior(false), this.method_23317(), this.method_23320(), this.method_23321(), 4.5f, false, class_1937.class_7867.field_40890, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880)class_3417.field_15152);
            this.initializedExplosion = true;
        }
        float health = this.method_6032() / this.method_6063();
        this.bossBar.method_5408(health);
        this.shieldBar.method_5408(this.shieldHealth / 336.0f);
        if (health > 0.0f && health < 0.2f && !this.getSecondPhase()) {
            world.method_43128((class_1297)((class_1657)null), this.method_23317(), this.method_23318(), this.method_23321(), Crying.CRIER_SCREAM_EVENT, this.method_5634(), 1.0f, 1.0f);
            world.method_8454((class_1297)this, class_1927.method_55108((class_1937)world, (class_1297)this), (class_5362)new CrierExplosionBehavior(true), this.method_23317(), this.method_23320(), this.method_23321(), 2.25f, false, class_1937.class_7867.field_40890, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880)class_3417.field_15152);
            this.switchToSecondPhase();
            this.setSecondPhase(true);
        }
        if (this.healing) {
            ++this.healingTicks;
            this.method_6033(this.method_6032() + 0.5f);
            if ((this.healingTicks - 1) % 4 == 0 || this.healingTicks >= 32) {
                this.method_37908().method_60511((class_1297)((class_1657)null), this.method_23317(), this.method_23318(), this.method_23321(), (class_6880)class_3417.field_20613, this.method_5634(), 1.0f, 1.0f);
            }
            if ((this.healingTicks - 1) % 8 == 0 || this.healingTicks >= 32) {
                this.method_6104(class_1268.field_5808);
            }
            if (this.healingTicks >= 32) {
                this.healing = false;
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)Crying.CRIERS_SWORD));
                class_1324 instance = this.method_5996(class_5134.field_23719);
                instance.method_6192(0.355);
                class_1324 instance2 = this.method_5996(class_5134.field_23720);
                instance2.method_6192(3.0);
            }
        }
    }

    void damageShield(float amount) {
        this.shieldHealth = amount < 3.0f ? (this.shieldHealth -= 1.0f) : (this.shieldHealth -= (float)Math.round(amount));
        this.method_37908().method_60511((class_1297)((class_1657)null), this.method_23317(), this.method_23318(), this.method_23321(), (class_6880)class_3417.field_15150, this.method_5634(), 1.0f, 1.0f);
        this.method_6104(class_1268.field_5810);
        if (this.shieldHealth <= 0.0f) {
            this.breakShield(true);
        }
    }

    void breakShield(boolean playSound) {
        this.shieldBar.method_14091(false);
        this.method_6122(class_1268.field_5810, class_1799.field_8037);
        this.shieldHealth = 0.0f;
        if (playSound) {
            this.method_37908().method_45447(null, this.method_24515(), (class_3414)class_3417.field_15239.comp_349(), this.method_5634());
        }
    }

    void changeScale() {
        class_1324 scale = this.method_5996(class_5134.field_47760);
        scale.method_6192(this.isSmall ? 0.495 : 1.0);
        if (this.isSmall) {
            this.method_18380(class_4050.field_18081);
        }
    }

    void switchToSecondPhase() {
        class_1324 damage = this.method_5996(class_5134.field_23721);
        damage.method_6192(4.0);
        this.bossBar.method_5413((class_2561)class_2561.method_43471((String)"entity.crying.forlorn.crier").method_10852(this.method_23315()));
    }

    void swingBothHands() {
        this.method_6104(class_1268.field_5808);
        this.method_6104(class_1268.field_5810);
    }

    public boolean getSecondPhase() {
        return (Boolean)this.method_5841().method_12789(secondPhase);
    }

    public void setSecondPhase(boolean phase) {
        this.method_5841().method_12778(secondPhase, (Object)phase);
    }

    protected void method_16077(class_3218 world, class_1282 damageSource, boolean causedByPlayer) {
        if (causedByPlayer) {
            class_1799 stack = new class_1799((class_1935)Crying.EYE);
            stack.method_7939(this.gotAttackedByPlayer.size());
            this.method_5775(world, stack);
            class_1799 heart = new class_1799((class_1935)Crying.CRIERS_HEART);
            heart.method_7939(1);
            this.method_5775(world, heart);
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
        this.shieldBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
        this.shieldBar.method_14089(player);
    }

    protected void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71472("secondPhase", this.getSecondPhase());
        nbt.method_71472("initializedExplosion", this.initializedExplosion);
        nbt.method_71472("healing", this.healing);
        nbt.method_71472("isSmall", this.isSmall);
        nbt.method_71464("shieldHealth", this.shieldHealth);
        nbt.method_71465("healingTicks", this.healingTicks);
        for (String s : this.gotAttackedByPlayer) {
            nbt.method_71472("UUID_SET_BY_CRYING_" + s, true);
        }
    }

    protected void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        if (nbt instanceof class_11352) {
            class_11352 nbtReadView = (class_11352)nbt;
            ((NbtInterface)nbtReadView).getNbt().method_68561((string, element) -> {
                if (string.startsWith("UUID_SET_BY_CRYING_") && element.method_68606().orElse(false).booleanValue()) {
                    this.gotAttackedByPlayer.add(string.replace("UUID_SET_BY_CRYING_", ""));
                }
            });
        }
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        this.initializedExplosion = nbt.method_71433("initializedExplosion", false);
        this.healing = nbt.method_71433("healing", false);
        if (this.healing) {
            this.heal();
        }
        this.healingTicks = nbt.method_71424("healingTicks", 0);
        this.setSecondPhase(nbt.method_71433("secondPhase", false));
        if (this.getSecondPhase()) {
            this.switchToSecondPhase();
        }
        this.isSmall = nbt.method_71433("isSmall", false);
        this.changeScale();
        this.shieldHealth = nbt.method_71423("shieldHealth", 336.0f);
        if (this.shieldHealth <= 0.0f) {
            this.breakShield(false);
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public boolean method_5807() {
        return super.method_5807() && !this.getSecondPhase();
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        float chance;
        boolean bl = super.method_6121(world, target);
        if (bl && target instanceof class_1657 && (chance = Math.abs(world.method_8409().method_43057())) < 0.2f) {
            float f = this.method_37908().method_8404(this.method_24515()).method_5457();
            ((class_1657)target).method_37222(new class_1293(class_1294.field_5911, 100 * (int)f), (class_1297)this);
        }
        return bl;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972;
        if (this.method_6032() - amount <= 0.0f && !(source.method_5529() instanceof class_1657) && !source.method_49708(class_8111.field_42348)) {
            this.method_6033(0.01f);
            if (!this.healing) {
                this.heal();
            }
            return false;
        }
        if (this.method_5757()) {
            return false;
        }
        if (this.healing) {
            return false;
        }
        if (source.method_48789(class_8103.field_42246)) {
            return false;
        }
        if (source.method_60948() != null && source.method_60948().method_7909() == class_1802.field_49814) {
            world.method_60511((class_1297)((class_1657)null), this.method_23317(), this.method_23318(), this.method_23321(), (class_6880)class_3417.field_15150, this.method_5634(), 1.0f, 1.0f);
            this.swingBothHands();
            return false;
        }
        if (source.method_49708(class_8111.field_42342) || source.method_48789(class_8103.field_42250)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42247)) {
            world.method_60511((class_1297)((class_1657)null), this.method_23317(), this.method_23318(), this.method_23321(), (class_6880)class_3417.field_15150, this.method_5634(), 1.0f, 1.0f);
            return false;
        }
        if (!source.method_48789(class_8103.field_56242) && this.method_6079().method_7909() == class_1802.field_8255 && this.shieldHealth > 0.0f) {
            this.damageShield(amount);
            return false;
        }
        float f = world.method_8409().method_43057();
        float f2 = this.getSecondPhase() ? 0.0f : 0.045f;
        if (f < f2) {
            world.method_8454((class_1297)this, class_1927.method_55108((class_1937)world, (class_1297)this), (class_5362)new CrierExplosionBehavior(true), this.method_23317(), this.method_23320(), this.method_23321(), 2.0f, false, class_1937.class_7867.field_40890, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880)class_3417.field_15152);
        }
        float f3 = this.getSecondPhase() ? 0.25f : 0.05f;
        if (f < f3) {
            this.heal();
        }
        if ((class_12972 = source.method_5529()) instanceof class_1657 && !this.gotAttackedByPlayer.contains((player = (class_1657)class_12972).method_5845())) {
            this.gotAttackedByPlayer.add(player.method_5845());
        }
        return super.method_64397(world, source, amount);
    }

    void heal() {
        if (this.healing) {
            return;
        }
        this.healing = true;
        this.healingTicks = 0;
        this.method_5673(class_1304.field_6173, class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8963));
        class_1324 instance = this.method_5996(class_5134.field_23719);
        instance.method_6192(0.001);
        class_1324 instance2 = this.method_5996(class_5134.field_23720);
        instance2.method_6192(0.001);
    }

    public void setCanBreakDoors(boolean canBreakDoors) {
        if (class_5493.method_30955((class_1308)this)) {
            ((class_1409)this.method_5942()).method_70687(true);
            this.field_6201.method_6277(1, (class_1352)new FastBreakDoorGoal((class_1308)this, difficulty -> true));
        }
    }

    public boolean method_6109() {
        return false;
    }

    protected int method_6110(class_3218 world) {
        return 0;
    }

    public void method_7217(boolean baby) {
    }

    public boolean method_5939(class_1799 stack) {
        return false;
    }

    public boolean method_20820(class_3218 world, class_1799 stack) {
        return false;
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
    }

    public static boolean shouldBeBaby(class_5819 random) {
        return false;
    }
}

