/*
 * Decompiled with CFR 0.152.
 */
package crying.mixin;

import com.mojang.authlib.GameProfile;
import crying.Crying;
import crying.entities.CrierEntity;
import crying.entities.GranterEntity;
import crying.entities.GrapplingHookEntity;
import crying.enums.CollapsingReason;
import crying.interfaces.BiomeVars;
import crying.interfaces.CryingTool;
import crying.interfaces.FoodVars;
import crying.interfaces.HookVars;
import crying.interfaces.SanityManager;
import crying.interfaces.SanityVars;
import crying.tools.CryingShieldItem;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5354;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements SanityVars,
HookVars,
FoodVars,
BiomeVars {
    SanityManager SanityManager;
    GrapplingHookEntity hook;
    int eatenCryingFoodCount = 0;
    int coldTicks = 0;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(class_1937 world, GameProfile profile, CallbackInfo info) {
        class_1657 player = (class_1657)this;
        this.SanityManager = new SanityManager(player.method_5845());
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    public void initDataTracker(class_2945.class_9222 builder, CallbackInfo info) {
        builder.method_56912(Crying.FOOD_COUNT, (Object)0);
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        class_1792 class_17922;
        class_1657 player = (class_1657)this;
        if (Crying.isTheCriersSword(source.method_60948()) && !(source.method_5529() instanceof CrierEntity)) {
            info.setReturnValue((Object)false);
        }
        if (!(player.method_5679(world, source) || source.method_48789(class_8103.field_42242) || source.method_48789(class_8103.field_42250) || source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42251) || source.method_48789(class_8103.field_42252))) {
            class_5354 angerable;
            class_1297 stack;
            class_1792 class_17923;
            class_1268 hand;
            if (!source.method_48789(class_8103.field_56242) && (hand = Crying.getHandThatHasCryingShield(player)) != null && (class_17923 = (stack = player.method_5998(hand)).method_7909()) instanceof CryingShieldItem) {
                CryingShieldItem item = (CryingShieldItem)class_17923;
                item.useShield((class_1799)stack, hand, player, source.method_5529(), source, Math.round(amount));
            }
            if (source.method_5529() instanceof class_1588 || (stack = source.method_5529()) instanceof class_5354 && (angerable = (class_5354)stack).method_29508() != null && angerable.method_29508().equals(player.method_5667())) {
                SanityManager manager = Crying.getSanityManager(player);
                manager.damage(amount);
            }
        }
        if ((class_17922 = player.method_6047().method_7909()) instanceof CryingTool) {
            CryingTool tool = (CryingTool)class_17922;
            if (tool.getCoreIngredient() == class_1802.field_22020) {
                if (source.method_48789(class_8103.field_42246)) {
                    player.method_6025(amount);
                    info.setReturnValue((Object)false);
                }
            } else if ((tool.getCoreIngredient() == class_1802.field_8695 || Crying.isTheCriersSword(player.method_6047())) && !player.method_68878() && source.method_5529() instanceof class_1297) {
                GranterEntity.summonGranterEntity((class_1937)world, player);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo info) {
        class_3222 serverPlayer;
        class_1657 player = (class_1657)this;
        if (player instanceof class_3222 && Crying.getSanityManager((class_1657)(serverPlayer = (class_3222)player)).getMaxLevel() > 0) {
            this.SanityManager.update(serverPlayer);
        }
    }

    @Inject(method={"onKilledOther"}, at={@At(value="TAIL")}, cancellable=true)
    public void onKilledOther(class_3218 world, class_1309 other, CallbackInfoReturnable<Boolean> info) {
        class_1299 type = other.method_5864();
        class_1657 player = (class_1657)this;
        SanityManager manager = Crying.getSanityManager(player);
        if (type == class_1299.field_16281 || other instanceof class_1321 && ((class_1321)other).method_6181() || type == class_1299.field_6077 || type == class_1299.field_17713 || type == class_1299.field_6147 || type == class_1299.field_6047 || type == class_1299.field_38384) {
            manager.collapse(Crying.tickSecond(900), (class_1309)player, CollapsingReason.MURDER);
        } else if (manager.getMaxLevel() > 0 && (other instanceof class_1588 || other instanceof class_1621)) {
            float decreaseValue = -1.0f;
            if (type == class_1299.field_6107 || type == class_1299.field_6091 || type == class_1299.field_6128) {
                decreaseValue = -5.0f;
            } else if (type == class_1299.field_6090) {
                decreaseValue = -4.0f;
            } else if (type == class_1299.field_6145) {
                decreaseValue = -8.0f;
            } else if (type == class_1299.field_6065) {
                decreaseValue = -16.0f;
            }
            manager.decreaseLevel(type == Crying.CRIER ? -20.0f : decreaseValue);
        }
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    public void readCustomData(class_11368 nbt, CallbackInfo info) {
        this.SanityManager.readNbt(nbt);
        this.setEatenCryingFoodCount(nbt.method_71424("eatenCryingFoodCount", 0));
        this.setTicksInColdBiome(nbt.method_71424("coldTicks", 0));
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    protected void writeCustomData(class_11372 nbt, CallbackInfo info) {
        this.SanityManager.writeNbt(nbt);
        nbt.method_71465("eatenCryingFoodCount", this.getEatenCryingFoodCount());
        nbt.method_71465("coldTicks", this.getTicksInColdBiome());
    }

    @Override
    public void setManager(SanityManager manager) {
        this.SanityManager = manager;
    }

    @Override
    public SanityManager getManager() {
        return this.SanityManager;
    }

    @Override
    public GrapplingHookEntity getHook() {
        return this.hook;
    }

    @Override
    public void setHook(GrapplingHookEntity entity) {
        this.hook = entity;
    }

    @Override
    public int getEatenCryingFoodCount() {
        class_1657 player = (class_1657)this;
        try {
            return (Integer)player.method_5841().method_12789(Crying.FOOD_COUNT);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public void setEatenCryingFoodCount(int count) {
        this.eatenCryingFoodCount = Math.min(count, 9888);
        class_1657 player = (class_1657)this;
        player.method_5841().method_12778(Crying.FOOD_COUNT, (Object)this.eatenCryingFoodCount);
    }

    @Override
    public int getTicksInColdBiome() {
        return this.coldTicks;
    }

    @Override
    public void setTicksInColdBiome(int tick) {
        this.coldTicks = tick;
    }
}

