/*
 * Decompiled with CFR 0.152.
 */
package crying.mixin;

import crying.Crying;
import crying.armors.CryingArmor;
import crying.effects.BaneOfCriers;
import crying.interfaces.LightningVars;
import crying.interfaces.OxidizableCryingTool;
import crying.interfaces.SanityManager;
import crying.items.CryingFoodItem;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5955;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Shadow
    boolean field_6282;

    @Inject(method={"damage"}, at={@At(value="TAIL")}, cancellable=true)
    public void damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        class_1309 thisEntity = (class_1309)this;
        class_1297 attacker = source.method_5529();
        if (!(thisEntity instanceof class_1657) && attacker instanceof class_3222) {
            OxidizableCryingTool tool;
            class_1792 class_17922;
            class_3222 player = (class_3222)attacker;
            class_1799 stack = source.method_60948();
            if (stack != null && (class_17922 = stack.method_7909()) instanceof OxidizableCryingTool && (tool = (OxidizableCryingTool)class_17922).getCoreIngredient() == class_1802.field_27022) {
                class_5955.class_5811 level = tool.getOxidationLevel(stack);
                float chance = 1.0f;
                if (level == class_5955.class_5811.field_28705) {
                    chance = 0.75f;
                }
                if (level == class_5955.class_5811.field_28706) {
                    chance = 0.5f;
                }
                if (level == class_5955.class_5811.field_28707) {
                    chance = 0.25f;
                }
                if (world.method_8409().method_43057() < chance) {
                    class_1538 entity = new class_1538(class_1299.field_6112, (class_1937)world);
                    entity.method_6961(player);
                    ((LightningVars)entity).set_playerThatSummonedLightningWithCopperCryingTool((class_1657)player);
                    entity.method_33574(thisEntity.method_19538());
                    world.method_8649((class_1297)entity);
                }
            }
        }
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="TAIL")}, cancellable=true)
    protected void applyArmorToDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> info) {
        class_1309 entity = (class_1309)this;
        if (CryingArmor.setCount(entity) > 0 && !source.method_48789(class_8103.field_42244)) {
            float dmg = ((Float)info.getReturnValue()).floatValue();
            float extraProtection = 0.0f;
            float i = (float)CryingArmor.setCount(entity) * 5.0f;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                SanityManager manager = Crying.getSanityManager(player);
                i *= manager.getSanityLevel() / (float)manager.getMaxLevel();
                i *= 4.0f;
                extraProtection = CryingFoodItem.getExtraProtectionFormula(player);
            }
            if (i > 80.0f) {
                i = 80.0f;
            }
            float rDmg = dmg - dmg * (i / 100.0f);
            info.setReturnValue((Object)Float.valueOf(rDmg * (1.0f - extraProtection)));
        }
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    protected void modifyAppliedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> info) {
        if (!source.method_48789(class_8103.field_42243)) {
            class_1657 player;
            class_1268 hand;
            class_1309 entity = (class_1309)this;
            float dmg = ((Float)info.getReturnValue()).floatValue();
            if (entity.method_6059(BaneOfCriers.BANE_OF_CRIERS)) {
                info.setReturnValue((Object)Float.valueOf(dmg * 2.0f));
            }
            if (!(!(entity instanceof class_1657) || (hand = Crying.getHandThatHasCryingShield(player = (class_1657)entity)) == null || player.method_5679((class_3218)player.method_37908(), source) || source.method_48789(class_8103.field_42242) || source.method_48789(class_8103.field_42250) || source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42251) || source.method_48789(class_8103.field_42252) || source.method_48789(class_8103.field_56242))) {
                info.setReturnValue((Object)Float.valueOf(dmg *= player.method_5715() ? 0.1f : 0.75f));
            }
        }
    }
}

