/*
 * Decompiled with CFR 0.152.
 */
package crying.mixin.client;

import crying.Crying;
import crying.interfaces.SanityManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public class InGameHudMixin {
    private static final class_2960 ARMOR_EMPTY_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/armor_empty");
    private static final class_2960 ARMOR_HALF_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/armor_half");
    private static final class_2960 ARMOR_HALF_TEXTURE_2 = class_2960.method_60655((String)"crying", (String)"hud/armor_half_2");
    private static final class_2960 ARMOR_FULL_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/armor_full");
    private static final class_2960 EMPTY_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/sanity_empty");
    private static final class_2960 HALF_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/sanity_half");
    private static final class_2960 FULL_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/sanity_full");
    private static final class_2960 MAX_HALF_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/sanity_half_max");
    private static final class_2960 MAX_EMPTY_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/sanity_half_empty");
    private static final class_2960 INACTIVE_TEXTURE = class_2960.method_60655((String)"crying", (String)"hud/sanity_inactive");

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")})
    private static void renderArmor(class_332 context, class_1657 player, int i, int j, int k, int x, CallbackInfo info) {
        int armor = player.method_6096();
        if (armor > 20) {
            int max = 20;
            if (armor > 40) {
                max = 30;
            }
            if (armor > 60) {
                max = 40;
            }
            int m = i - (j - 1) * k - 20;
            for (int n = 10; n < max; ++n) {
                int o = x + (n - 10) * 8;
                if (n >= 20) {
                    o = context.method_51421() / 2 + 91 - (n - 20) * 8 - 9;
                    m = i - (j - 1) * k - 10;
                }
                if (n >= 30) {
                    o = context.method_51421() / 2 + 91 - (n - 30) * 8 - 9;
                    m = i - (j - 1) * k - 20;
                }
                if (n * 2 + 1 < armor) {
                    context.method_52706(class_1921::method_62277, ARMOR_FULL_TEXTURE, o, m, 9, 9);
                }
                if (n * 2 + 1 == armor) {
                    context.method_52706(class_1921::method_62277, n >= 20 ? ARMOR_HALF_TEXTURE_2 : ARMOR_HALF_TEXTURE, o, m, 9, 9);
                }
                if (n * 2 + 1 <= armor) continue;
                context.method_52706(class_1921::method_62277, ARMOR_EMPTY_TEXTURE, o, m, 9, 9);
            }
        }
    }

    @Inject(method={"renderFood"}, at={@At(value="HEAD")})
    private void renderFood(class_332 context, class_1657 player, int top, int right, CallbackInfo info) {
        SanityManager manager = SanityManager.getFromUUID(player.method_5845());
        class_329 hud = (class_329)this;
        if (manager == null) {
            manager = new SanityManager(player.method_5845());
        }
        if (!manager.isActive) {
            return;
        }
        int a = player.method_5748();
        int c = Math.clamp((long)player.method_5669(), 0, a);
        boolean bl = player.method_5777(class_3486.field_15517) || c < a;
        float i = manager.getSanityLevel();
        float max = Math.round((float)manager.getMaxLevel() / 2.0f);
        int k = top - 10 - (bl ? 10 : 0);
        for (int j = 0; j < Math.round(max); ++j) {
            int l = right - j * 8 - 9;
            float dec = Crying.floorDecimal((float)manager.getMaxLevel() / 2.0f, 1);
            boolean ishalf = dec == 2.5f || dec == 7.5f;
            class_2960 half = HALF_TEXTURE;
            class_2960 empty = EMPTY_TEXTURE;
            class_2960 full = FULL_TEXTURE;
            if (ishalf && j == Math.round(max) - 1) {
                full = MAX_HALF_TEXTURE;
                half = MAX_HALF_TEXTURE;
                empty = MAX_EMPTY_TEXTURE;
            }
            if (manager.getCollapseRegenTicks() > 0) {
                context.method_52706(class_1921::method_62277, INACTIVE_TEXTURE, l, k, 9, 9);
                continue;
            }
            if ((float)j * 2.0f + 1.0f < i) {
                context.method_52706(class_1921::method_62277, full, l, k, 9, 9);
                continue;
            }
            if ((float)j * 2.0f + 1.0f == i) {
                context.method_52706(class_1921::method_62277, half, l, k, 9, 9);
                continue;
            }
            context.method_52706(class_1921::method_62277, empty, l, k, 9, 9);
        }
        if (manager.getCollapseRegenTicks() > 0 && manager.getMaxLevel() > 0) {
            class_5250 text = class_2561.method_43471((String)"sanity.collapsed");
            text.method_10852((class_2561)manager.getCollapsingReason().getTranslatableName());
            class_5250 text2 = class_2561.method_43471((String)"sanity.recovering");
            text2.method_10852((class_2561)class_2561.method_43470((String)Crying.tickToString(manager.getCollapseRegenTicks())).method_10862(class_2583.field_24360.method_10977(manager.getCollapseMultiplier() > 1 ? class_124.field_1075 : class_124.field_1068)));
            int ll = (context.method_51421() - hud.method_1756().method_27525((class_5348)text)) / 2;
            context.method_60649(hud.method_1756(), (class_2561)text, ll, k - 30 - (bl ? -10 : 0), hud.method_1756().method_27525((class_5348)text), 0xFFFFFF);
            int ll2 = (context.method_51421() - hud.method_1756().method_27525((class_5348)text2)) / 2;
            context.method_60649(hud.method_1756(), (class_2561)text2, ll2, k - 20 - (bl ? -10 : 0), hud.method_1756().method_27525((class_5348)text2), 0xFFFFFF);
        }
    }
}

