/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.client;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.Activator;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.surgebinding.common.manifestation.SurgebindingManifestation;
import leaf.cosmere.surgebinding.common.registries.SurgebindingManifestations;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="surgebinding", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SurgebindingKeybindings {
    public static KeyMapping SHARDBLADE;
    public static KeyMapping REQUEST_STORMLIGHT;
    public static KeyMapping DISPATCH_STORMLIGHT;
    public static final Map<Roshar.Surges, KeyMapping> SURGEBINDING_POWER;

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        SHARDBLADE = new KeyMapping("key.cosmere.stormlight.shardblade", 88, "keys.cosmere.main");
        event.register(SHARDBLADE);
        for (Roshar.Surges surge : SURGEBINDING_POWER.keySet()) {
            KeyMapping key = SURGEBINDING_POWER.get(surge);
            SurgebindingManifestation manifest = (SurgebindingManifestation)SurgebindingManifestations.SURGEBINDING_POWERS.get(surge).getManifestation();
            event.register(key);
            Activator entry = new Activator(key, (Manifestation)manifest);
            entry.setCategory("stormlight");
            Keybindings.activators.add(entry);
        }
        SHARDBLADE = new KeyMapping("key.cosmere.stormlight.shardblade", 88, "keys.surgebinding.main");
        event.register(SHARDBLADE);
        REQUEST_STORMLIGHT = new KeyMapping("key.cosmere.stormlight.request_stormlight", 90, "keys.surgebinding.main");
        event.register(REQUEST_STORMLIGHT);
        DISPATCH_STORMLIGHT = new KeyMapping("key.cosmere.stormlight.dispatch_stormlight", 89, "keys.surgebinding.main");
        event.register(DISPATCH_STORMLIGHT);
    }

    static {
        SURGEBINDING_POWER = Arrays.stream(EnumUtils.SURGES).collect(Collectors.toMap(Function.identity(), surge -> new KeyMapping("key.cosmere.stormlight." + surge.getName(), -1, "keys.cosmere.activators")));
    }
}

