/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.capabilities.ideals;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.util.TaskQueueManager;
import leaf.cosmere.surgebinding.common.capabilities.ideals.order.WindrunnerIdealStateManager;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.config.SurgebindingServerConfig;
import leaf.cosmere.surgebinding.common.registries.SurgebindingManifestations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.ServerChatEvent;
import org.jetbrains.annotations.NotNull;

public class RadiantStateManager {
    private static ResourceLocation SWEAR_IDEAL = new ResourceLocation("surgebinding", "swear_ideal");
    private SpiritwebCapability spiritweb;
    private Roshar.RadiantOrder order = null;
    private int ideal = 0;

    public Roshar.RadiantOrder getOrder() {
        return this.order;
    }

    public int getIdeal() {
        return this.ideal;
    }

    public void serialize(ISpiritweb spiritweb) {
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        if (this.order != null) {
            compoundTag.m_128405_("order", this.order.getID());
        } else if (compoundTag.m_128441_("order")) {
            compoundTag.m_128473_("order");
        }
        compoundTag.m_128405_("ideal", this.ideal);
    }

    public void deserialize(ISpiritweb spiritweb) {
        this.spiritweb = (SpiritwebCapability)spiritweb;
        CompoundTag spiritwebCompoundTag = spiritweb.getCompoundTag();
        this.order = spiritwebCompoundTag.m_128441_("order") ? (Roshar.RadiantOrder)Roshar.RadiantOrder.valueOf((int)spiritwebCompoundTag.m_128451_("order")).orElse(null) : null;
        this.ideal = spiritwebCompoundTag.m_128451_("ideal");
    }

    public void onChatMessageReceived(ServerChatEvent event) {
        String playerMessage = SurgebindingServerConfig.cleanIdeal(event.getRawText());
        int idealToSwear = 0;
        Roshar.RadiantOrder idealOrder = null;
        boolean foundAssociatedIdeal = false;
        if (idealToSwear <= this.ideal) {
            return;
        }
        block0: for (Roshar.RadiantOrder radiantOrder : EnumUtils.RADIANT_ORDERS) {
            if (foundAssociatedIdeal) break;
            for (int ideal = 1; ideal <= 5; ++ideal) {
                String thisIdeal = SurgebindingConfigs.SERVER.getIdeal(ideal, radiantOrder.getID());
                if (thisIdeal.equals("notyetimplemented") || !playerMessage.contains(thisIdeal)) continue;
                idealToSwear = ideal;
                if (idealToSwear != 1) {
                    idealOrder = radiantOrder;
                }
                foundAssociatedIdeal = true;
                continue block0;
            }
        }
        if (idealToSwear == 0) {
            return;
        }
        if (this.ideal > 2 && this.order == null) {
            CosmereAPI.logger.error("Player has sworn a higher ideal but has no order set?? How does this happen. Resetting to zero.");
            this.ideal = 0;
        }
        if (this.ideal == 0 && this.order != null) {
            CosmereAPI.logger.error("Player has an order despite swearing no oaths?. Resetting.");
            this.order = null;
        }
        boolean successfulSwear = false;
        if (this.order == null) {
            if (idealToSwear == 1 && this.ideal == 0) {
                successfulSwear = this.onTrySuccessfulSwear(idealToSwear, null);
            } else if (idealToSwear == 2 && this.ideal == 1) {
                successfulSwear = this.onTrySuccessfulSwear(idealToSwear, idealOrder);
            }
            if (successfulSwear) {
                ++this.ideal;
                this.order = idealOrder;
                this.onSuccessfulIdealSworn(this.spiritweb);
            }
            return;
        }
        if (this.order.equals(idealOrder)) {
            boolean swearingHigherIdeal;
            boolean bl = swearingHigherIdeal = idealToSwear > 2;
            if (idealToSwear == this.ideal + 1) {
                successfulSwear = this.onTrySuccessfulSwear(idealToSwear, idealOrder);
            }
            if (successfulSwear) {
                ++this.ideal;
                this.onSuccessfulIdealSworn(this.spiritweb);
            } else {
                event.setCanceled(true);
                event.getPlayer().m_213846_((Component)Component.m_237113_((String)"THESE WORDS ARE NOT ACCEPTED."));
            }
        }
    }

    private boolean onTrySuccessfulSwear(int idealToSwear, Roshar.RadiantOrder idealOrder) {
        if (idealToSwear == 1 && idealOrder == null) {
            return true;
        }
        switch (idealOrder) {
            case WINDRUNNER: {
                return WindrunnerIdealStateManager.validateIdeal(this.spiritweb, idealToSwear);
            }
            case SKYBREAKER: {
                break;
            }
            case DUSTBRINGER: {
                break;
            }
            case EDGEDANCER: {
                break;
            }
            case TRUTHWATCHER: {
                break;
            }
            case LIGHTWEAVER: {
                break;
            }
            case ELSECALLER: {
                break;
            }
            case WILLSHAPER: {
                break;
            }
            case STONEWARD: {
                break;
            }
        }
        return false;
    }

    private void onSuccessfulIdealSworn(@NotNull SpiritwebCapability spiritweb) {
        LivingEntity livingEntity = spiritweb.getLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Runnable work = () -> {
                if (this.ideal != 1) {
                    player.m_213846_((Component)Component.m_237113_((String)"THESE WORDS ARE ACCEPTED."));
                    this.updatePowerState();
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + player.m_217043_().m_188501_() * 0.2f);
            };
            TaskQueueManager.submitDelayedTask((ResourceLocation)SWEAR_IDEAL, (int)60, (TaskQueueManager.Task)new TaskQueueManager.OneOffTask(work));
        }
    }

    private void updatePowerState() {
        Manifestation firstSurge = (Manifestation)SurgebindingManifestations.SURGEBINDING_POWERS.get(this.order.getFirstSurge()).get();
        Manifestation secondSurge = (Manifestation)SurgebindingManifestations.SURGEBINDING_POWERS.get(this.order.getSecondSurge()).get();
        this.spiritweb.giveManifestation(firstSurge, this.getIdeal());
        this.spiritweb.giveManifestation(secondSurge, this.getIdeal());
    }
}

