/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.config;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SurgebindingServerConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.IntValue MAX_SHARDBLADES;
    public final ForgeConfigSpec.IntValue PLAYER_MAX_STORMLIGHT;
    public final ForgeConfigSpec.IntValue PLAYER_DRAW_SPEED;
    public final ForgeConfigSpec.IntValue STORMLIGHT_DRAIN_RATE;
    public final ForgeConfigSpec.IntValue PROGRESSION_BONEMEAL_COST;
    public final ForgeConfigSpec.IntValue PROGRESSION_HEAL_COST;
    public final ForgeConfigSpec.IntValue PROGRESSION_AGE_UP_COST;
    public final ForgeConfigSpec.BooleanValue NIGHTBLOOD_SPOILERS;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> SECOND_IDEALS;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> THIRD_IDEALS;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> FOURTH_IDEALS;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> FIFTH_IDEALS;
    public static final String IDEAL_NOT_IMPLEMENTED = "notyetimplemented";

    SurgebindingServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Surgebinding Config. This config is synced between server and client.").push("surgebinding");
        this.MAX_SHARDBLADES = builder.comment("How many shardblades total that the user can bond").defineInRange("shardbladeBondAmount", 10, 0, 20);
        this.PLAYER_MAX_STORMLIGHT = builder.comment("How much stormlight can a player hold at once").defineInRange("playerMaxStormlight", 5000, 100, 20000);
        this.PLAYER_DRAW_SPEED = builder.comment("How fast a player draws in or breathes out stormlight using keybinds.").defineInRange("playerDrawSpeed", 150, 5, 20000);
        this.STORMLIGHT_DRAIN_RATE = builder.comment("How many points of stormlight drain per second").defineInRange("stormlightDrainRate", 5, 1, 100);
        this.PROGRESSION_BONEMEAL_COST = builder.comment("How many points of stormlight to trigger the bonemeal effect").defineInRange("progressionBonemealStormlightCost", 20, 1, 1000);
        this.PROGRESSION_HEAL_COST = builder.comment("How many points of stormlight per half a heart healed").defineInRange("progressionHealStormlightCost", 20, 1, 1000);
        this.PROGRESSION_AGE_UP_COST = builder.comment("How many points of stormlight per age up on a baby mob").defineInRange("progressionAgeUpCost", 50, 1, 1000);
        this.NIGHTBLOOD_SPOILERS = builder.comment("Enable this to allow Nightblood to have certain feature, which is spoilers for WindAndTruth").define("nightbloodSpoilers", true);
        Predicate<Object> elementValidator = o -> o instanceof String;
        this.SECOND_IDEALS = builder.defineList("second_ideals", List.of("I will protect those who cannot protect themselves.", "I will put the law before all else.", "I will seek self-mastery", "I will remember those who have been forgotten", "I will seek the truth", IDEAL_NOT_IMPLEMENTED, "I will reach my potential", "I will seek freedom for those in bondage.", "I will stand when others fall.", "I will unite instead of divide."), elementValidator);
        this.THIRD_IDEALS = builder.defineList("third_ideals", List.of("I will protect even those I hate, so long as it is right.", IDEAL_NOT_IMPLEMENTED, "I will strive to create rather than destroy", "I will listen to those who have been ignored.", IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, "I will achieve my goals, no matter the cost", IDEAL_NOT_IMPLEMENTED, "I will be the foundation on which others can build.", "I will take responsibility for what I have done. If I must fall, I will rise each time a better"), elementValidator);
        this.FOURTH_IDEALS = builder.defineList("fourth_ideals", List.of("I accept that there will be those I cannot protect.", IDEAL_NOT_IMPLEMENTED, "I will accept that destruction is sometimes necessary", IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, "I will accept that some goals are unobtainable", IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED), elementValidator);
        this.FIFTH_IDEALS = builder.defineList("fifth_ideals", List.of("I will protect myself, so that I may continue to protect others. ", "I am the law", IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED, IDEAL_NOT_IMPLEMENTED), elementValidator);
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "SurgebindingServer";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public void clearCache() {
        this.MAX_SHARDBLADES.clearCache();
        this.PLAYER_MAX_STORMLIGHT.clearCache();
        this.STORMLIGHT_DRAIN_RATE.clearCache();
        this.PROGRESSION_BONEMEAL_COST.clearCache();
        this.PROGRESSION_HEAL_COST.clearCache();
        this.PROGRESSION_AGE_UP_COST.clearCache();
    }

    public String getIdeal(int ideal, int order) {
        String idealString = null;
        switch (ideal) {
            default: {
                idealString = "life before death, strength before weakness, journey before destination";
                break;
            }
            case 2: {
                idealString = (String)((List)this.SECOND_IDEALS.get()).get(order);
                break;
            }
            case 3: {
                idealString = (String)((List)this.THIRD_IDEALS.get()).get(order);
                break;
            }
            case 4: {
                idealString = (String)((List)this.FOURTH_IDEALS.get()).get(order);
                break;
            }
            case 5: {
                idealString = (String)((List)this.FIFTH_IDEALS.get()).get(order);
            }
        }
        return SurgebindingServerConfig.cleanIdeal(idealString);
    }

    public static String cleanIdeal(String idealString) {
        String cleanedString = idealString.replace(" ", "").replace(",", "").replace(".", "").replace(";", "").toLowerCase(Locale.ROOT);
        return cleanedString;
    }
}

