/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.items;

import leaf.cosmere.api.IHasGemType;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.ChargeableItemBase;
import leaf.cosmere.common.properties.PropTypes;
import leaf.cosmere.surgebinding.common.capabilities.SurgebindingSpiritwebSubmodule;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.registries.SurgebindingDimensions;
import leaf.cosmere.surgebinding.common.registries.SurgebindingManifestations;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class GemstoneItem
extends ChargeableItemBase
implements IHasGemType {
    private final Roshar.Gemstone gemstone;
    private final Roshar.GemSize gemSize;

    public GemstoneItem(Roshar.Gemstone gemstone, Roshar.GemSize gemSize) {
        super(((Item.Properties)PropTypes.Items.SIXTY_FOUR.get()).m_41497_(Rarity.UNCOMMON));
        this.gemstone = gemstone;
        this.gemSize = gemSize;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return Mth.m_14143_((float)(10000.0f * this.getMaxChargeModifier())) * itemStack.m_41613_();
    }

    public float getMaxChargeModifier() {
        return this.gemSize.getChargeModifier();
    }

    public Roshar.Gemstone getGemType() {
        return this.gemstone;
    }

    public Roshar.GemSize getSize() {
        return this.gemSize;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (entityItem.m_9236_().m_46472_().equals(SurgebindingDimensions.ROSHAR_DIM_KEY) && entityItem.m_9236_().m_46758_(entityItem.m_20183_()) && entityItem.m_9236_().m_46470_() && this.getCharge(stack) < this.getMaxCharge(stack)) {
            this.increaseCurrentCharge(stack, 5);
        }
        return super.onEntityItemUpdate(stack, entityItem);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        Item item;
        if (!pLevel.m_46472_().equals(SurgebindingDimensions.ROSHAR_DIM_KEY)) {
            return;
        }
        if (pLevel.m_46758_(pEntity.m_20183_()) && pLevel.m_46470_() && (item = pStack.m_41720_()) instanceof GemstoneItem) {
            GemstoneItem gemstoneItem = (GemstoneItem)item;
            gemstoneItem.increaseCurrentCharge(pStack);
        }
        super.m_6883_(pStack, pLevel, pEntity, pItemSlot, pIsSelected);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        SpiritwebCapability.get((LivingEntity)pPlayer).ifPresent(spiritweb -> {
            SpiritwebCapability data = (SpiritwebCapability)spiritweb;
            boolean hasAnySurgebinding = SurgebindingManifestations.SURGEBINDING_POWERS.values().stream().anyMatch(manifestation -> spiritweb.hasManifestation(manifestation.getManifestation()));
            if (!hasAnySurgebinding) {
                return;
            }
            int charge = this.getCharge(itemStack);
            SurgebindingSpiritwebSubmodule sb = (SurgebindingSpiritwebSubmodule)data.getSubmodule(Manifestations.ManifestationTypes.SURGEBINDING);
            int playerStormlight = sb.getStormlight();
            int maxPlayerStormlight = (Integer)SurgebindingConfigs.SERVER.PLAYER_MAX_STORMLIGHT.get();
            if (!pPlayer.m_6047_()) {
                int attemptedTotal = charge + playerStormlight;
                if (attemptedTotal <= maxPlayerStormlight) {
                    sb.adjustStormlight(charge, true);
                    this.setCharge(itemStack, 0);
                } else {
                    int remainder = attemptedTotal - maxPlayerStormlight;
                    int chargeLevelUsed = charge - remainder;
                    sb.adjustStormlight(chargeLevelUsed, true);
                    this.adjustCharge(itemStack, -chargeLevelUsed);
                }
            } else if (playerStormlight > 0) {
                if (charge + playerStormlight > this.getMaxCharge(itemStack)) {
                    sb.adjustStormlight(-(this.getMaxCharge(itemStack) - charge), true);
                    this.setCharge(itemStack, this.getMaxCharge(itemStack));
                } else {
                    sb.adjustStormlight(-playerStormlight, true);
                    this.setCharge(itemStack, (short)(playerStormlight + charge));
                }
            }
        });
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }
}

