/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.items.ShardbladeItem;
import leaf.cosmere.surgebinding.common.registries.SurgebindingAttributes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;

public class NightbloodItem
extends ShardbladeItem {
    private Multimap<Attribute, AttributeModifier> attributeModifiers = null;
    protected static final UUID NIGHTBLOOD_SURGE_UUID = UUID.fromString("CB3F55D3-4865-4180-A497-9C13A33DB5CC");

    public NightbloodItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
    }

    @Override
    public boolean canSummonDismiss(Player player) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.attributeModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeedIn, AttributeModifier.Operation.ADDITION));
            if (((Boolean)SurgebindingConfigs.SERVER.NIGHTBLOOD_SPOILERS.get()).booleanValue()) {
                for (Roshar.Surges surge : EnumUtils.SURGES) {
                    builder.put((Object)SurgebindingAttributes.SURGEBINDING_ATTRIBUTES.get(surge).getAttribute(), (Object)new AttributeModifier(NIGHTBLOOD_SURGE_UUID, "Nightblood", 5.0, AttributeModifier.Operation.ADDITION));
                }
            }
            this.attributeModifiers = builder.build();
        }
        return switch (equipmentSlot) {
            case EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND -> this.attributeModifiers;
            default -> super.getAttributeModifiers(equipmentSlot, stack);
        };
    }
}

