/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.items;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import leaf.cosmere.client.render.CosmereRenderers;
import leaf.cosmere.surgebinding.client.render.model.ShardplateModel;
import leaf.cosmere.surgebinding.client.render.renderer.ArmorRenderer;
import leaf.cosmere.surgebinding.common.items.tiers.ShardplateArmorMaterial;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ShardplateItem
extends ArmorItem {
    public ShardplateItem(ShardplateArmorMaterial material, ArmorItem.Type pType, Item.Properties properties) {
        super((ArmorMaterial)material, pType, properties);
    }

    @Nonnull
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "surgebinding:textures/models/armor/shardplate.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @Nullable
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                Object t;
                Optional armorModel = CosmereRenderers.getRenderer((Item)itemStack.m_41720_());
                if (armorModel.isPresent() && (t = armorModel.get()) instanceof ArmorRenderer) {
                    ArmorRenderer armorRenderer = (ArmorRenderer)t;
                    boolean isHead = equipmentSlot == EquipmentSlot.HEAD;
                    boolean isChest = equipmentSlot == EquipmentSlot.CHEST;
                    boolean isLegs = equipmentSlot == EquipmentSlot.LEGS;
                    boolean isFeet = equipmentSlot == EquipmentSlot.FEET;
                    ShardplateModel model = armorRenderer.model;
                    model.f_102809_.f_104207_ = false;
                    model.f_102808_.f_104207_ = isHead;
                    model.f_102810_.f_104207_ = isChest;
                    model.Chestplate.f_104207_ = isChest;
                    model.f_102811_.f_104207_ = isChest;
                    model.f_102812_.f_104207_ = isChest;
                    model.f_102813_.f_104207_ = true;
                    model.f_102814_.f_104207_ = true;
                    model.LeftLeg.f_104207_ = isLegs;
                    model.RightLeg.f_104207_ = isLegs;
                    model.LeftBoot.f_104207_ = isFeet;
                    model.RightBoot.f_104207_ = isFeet;
                    return model;
                }
                return null;
            }
        });
    }
}

