/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.network.packets;

import java.util.UUID;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.network.ICosmerePacket;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.items.HonorbladeItem;
import leaf.cosmere.surgebinding.common.items.ShardbladeItem;
import leaf.cosmere.surgebinding.common.registries.SurgebindingAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SummonShardblade
implements ICosmerePacket {
    public SummonShardblade() {
    }

    public SummonShardblade(FriendlyByteBuf buffer) {
    }

    public void handle(NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        MinecraftServer server = sender.m_20194_();
        server.m_18689_(() -> SpiritwebCapability.get((LivingEntity)sender).ifPresent(cap -> {
            block2: {
                ShardbladeItem shardbladeItem;
                int maxShardblades;
                ItemStack itemInHand;
                LivingEntity livingEntity;
                CompoundTag shardblades;
                block3: {
                    CompoundTag spiritwebTags = cap.getCompoundTag();
                    shardblades = CompoundNBTHelper.getOrCreate((CompoundTag)spiritwebTags, (String)"shardblades");
                    livingEntity = cap.getLiving();
                    itemInHand = livingEntity.m_21120_(InteractionHand.MAIN_HAND);
                    maxShardblades = (Integer)SurgebindingConfigs.SERVER.MAX_SHARDBLADES.get();
                    if (!itemInHand.m_41619_()) break block3;
                    for (int i = 0; i < maxShardblades; ++i) {
                        String pKey = String.valueOf(i);
                        if (!shardblades.m_128441_(pKey)) continue;
                        CompoundTag test = shardblades.m_128469_(pKey);
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)test);
                        livingEntity.m_21008_(InteractionHand.MAIN_HAND, stack);
                        shardblades.m_128473_(pKey);
                        Item patt2284$temp = stack.m_41720_();
                        if (!(patt2284$temp instanceof HonorbladeItem)) break block2;
                        HonorbladeItem honorbladeItem = (HonorbladeItem)patt2284$temp;
                        SummonShardblade.UpdateIntrinsicPowers(honorbladeItem, livingEntity, false);
                        break block2;
                    }
                    break block2;
                }
                Item patt2611$temp = itemInHand.m_41720_();
                if (!(patt2611$temp instanceof ShardbladeItem) || !(shardbladeItem = (ShardbladeItem)patt2611$temp).canSummonDismiss((Player)sender)) break block2;
                for (int i = 0; i < maxShardblades; ++i) {
                    String pKey = String.valueOf(i);
                    if (shardblades.m_128441_(pKey)) continue;
                    shardblades.m_128365_(pKey, (Tag)itemInHand.serializeNBT());
                    livingEntity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    if (!(shardbladeItem instanceof HonorbladeItem)) break;
                    HonorbladeItem honorbladeItem = (HonorbladeItem)shardbladeItem;
                    SummonShardblade.UpdateIntrinsicPowers(honorbladeItem, livingEntity, true);
                    break;
                }
            }
        }));
        context.setPacketHandled(true);
    }

    private static void UpdateIntrinsicPowers(HonorbladeItem honorbladeItem, LivingEntity livingEntity, boolean isStoringHonorblade) {
        Roshar.RadiantOrder radiantOrder = honorbladeItem.radiantOrder;
        UUID uuid = UUID.fromString(radiantOrder.getName());
        Attribute firstSurge = SurgebindingAttributes.SURGEBINDING_ATTRIBUTES.get(radiantOrder.getFirstSurge()).getAttribute();
        Attribute secondSurge = SurgebindingAttributes.SURGEBINDING_ATTRIBUTES.get(radiantOrder.getSecondSurge()).getAttribute();
        if (isStoringHonorblade) {
            livingEntity.m_21051_(firstSurge).m_22125_(new AttributeModifier(uuid, radiantOrder.getName() + "PrimaryHonorbladeSurge", 5.0, AttributeModifier.Operation.ADDITION));
            livingEntity.m_21051_(secondSurge).m_22125_(new AttributeModifier(uuid, radiantOrder.getName() + "SecondaryHonorbladeSurge", 5.0, AttributeModifier.Operation.ADDITION));
        } else {
            livingEntity.m_21051_(firstSurge).m_22127_(uuid);
            livingEntity.m_21051_(secondSurge).m_22127_(uuid);
        }
    }

    public void encode(FriendlyByteBuf buf) {
    }
}

