/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.registries;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.common.properties.PropTypes;
import leaf.cosmere.common.registration.impl.ItemDeferredRegister;
import leaf.cosmere.common.registration.impl.ItemRegistryObject;
import leaf.cosmere.surgebinding.common.items.GemstoneItem;
import leaf.cosmere.surgebinding.common.items.HonorbladeItem;
import leaf.cosmere.surgebinding.common.items.NightbloodItem;
import leaf.cosmere.surgebinding.common.items.ShardbladeDynamicItem;
import leaf.cosmere.surgebinding.common.items.ShardbladeItem;
import leaf.cosmere.surgebinding.common.items.ShardplateItem;
import leaf.cosmere.surgebinding.common.items.tiers.ShardbladeItemTier;
import leaf.cosmere.surgebinding.common.items.tiers.ShardplateArmorMaterial;
import leaf.cosmere.surgebinding.common.registries.SurgebindingEntityTypes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class SurgebindingItems {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("surgebinding");
    public static final ShardbladeItemTier SHARDBLADE_ITEM_TIER = new ShardbladeItemTier(10.0f);
    public static final ItemRegistryObject<ShardbladeItem> NIGHTBLOOD = ITEMS.register("nightblood", () -> new NightbloodItem(SHARDBLADE_ITEM_TIER, 24, -2.4f, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardbladeItem> TEST_BLADE = ITEMS.register("test_blade", () -> new ShardbladeItem(SHARDBLADE_ITEM_TIER, 10, -2.4f, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardbladeItem> SHARDBLADE = ITEMS.register("shardblade", () -> new ShardbladeDynamicItem(SHARDBLADE_ITEM_TIER, 24, -2.4f, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardbladeItem> MASTER_SWORD = ITEMS.register("master_sword", () -> new ShardbladeItem(SHARDBLADE_ITEM_TIER, 10, -2.4f, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardplateItem> SHARDPLATE_HELMET = ITEMS.register("shardplate_helmet", () -> new ShardplateItem(ShardplateArmorMaterial.DEADPLATE, ArmorItem.Type.HELMET, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardplateItem> SHARDPLATE_CHEST = ITEMS.register("shardplate_chest", () -> new ShardplateItem(ShardplateArmorMaterial.DEADPLATE, ArmorItem.Type.CHESTPLATE, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardplateItem> SHARDPLATE_LEGGINGS = ITEMS.register("shardplate_leggings", () -> new ShardplateItem(ShardplateArmorMaterial.DEADPLATE, ArmorItem.Type.LEGGINGS, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final ItemRegistryObject<ShardplateItem> SHARDPLATE_BOOTS = ITEMS.register("shardplate_boots", () -> new ShardplateItem(ShardplateArmorMaterial.DEADPLATE, ArmorItem.Type.BOOTS, (Item.Properties)PropTypes.Items.SHARDBLADE.get()));
    public static final Map<Roshar.RadiantOrder, ItemRegistryObject<HonorbladeItem>> HONORBLADES = Arrays.stream(EnumUtils.RADIANT_ORDERS).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.getName() + "_honorblade", () -> new HonorbladeItem((Roshar.RadiantOrder)type, SHARDBLADE_ITEM_TIER, 24, -2.4f, (Item.Properties)PropTypes.Items.SHARDBLADE.get()))));
    public static final Map<Roshar.Gemstone, ItemRegistryObject<GemstoneItem>> GEMSTONE_CHIPS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.getName() + "_chip", () -> new GemstoneItem((Roshar.Gemstone)type, Roshar.GemSize.CHIP))));
    public static final Map<Roshar.Gemstone, ItemRegistryObject<GemstoneItem>> GEMSTONE_MARKS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.getName() + "_mark", () -> new GemstoneItem((Roshar.Gemstone)type, Roshar.GemSize.MARK))));
    public static final Map<Roshar.Gemstone, ItemRegistryObject<GemstoneItem>> GEMSTONE_BROAMS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.getName() + "_broam", () -> new GemstoneItem((Roshar.Gemstone)type, Roshar.GemSize.BROAM))));
    public static final ItemRegistryObject<ForgeSpawnEggItem> CHULL_EGG = ITEMS.registerSpawnEgg(SurgebindingEntityTypes.CHULL, 7096367, 9050632);
    public static final ItemRegistryObject<ForgeSpawnEggItem> CRYPTIC_EGG = ITEMS.registerSpawnEgg(SurgebindingEntityTypes.CRYPTIC, 0x272727, 0x4D4D4D);

    private SurgebindingItems() {
    }
}

