/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.items.CapWrapper;
import leaf.cosmere.surgebinding.common.capabilities.ideals.RadiantStateManager;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.items.GemstoneItem;
import leaf.cosmere.surgebinding.common.items.tiers.ShardplateArmorMaterial;
import leaf.cosmere.surgebinding.common.manifestation.SurgeProgression;
import leaf.cosmere.surgebinding.common.registries.SurgebindingDimensions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class SurgebindingSpiritwebSubmodule
implements ISpiritwebSubmodule {
    private int stormlightStored = 0;
    private boolean herald = false;
    int maxPlayerStormlight;
    int drawSpeed;
    public static final ShardplateArmorMaterial[] ARMOR_MATERIALS = ShardplateArmorMaterial.values();
    RadiantStateManager idealsManager;
    private ISpiritweb spiritweb;

    public SurgebindingSpiritwebSubmodule() {
        this.maxPlayerStormlight = (Integer)SurgebindingConfigs.SERVER.PLAYER_MAX_STORMLIGHT.get();
        this.drawSpeed = (Integer)SurgebindingConfigs.SERVER.PLAYER_DRAW_SPEED.get();
        this.idealsManager = new RadiantStateManager();
    }

    public static SurgebindingSpiritwebSubmodule getSubmodule(ISpiritweb data) {
        return (SurgebindingSpiritwebSubmodule)data.getSubmodule(Manifestations.ManifestationTypes.SURGEBINDING);
    }

    public boolean isHerald() {
        return this.herald;
    }

    public boolean isOathed() {
        return this.idealsManager.getOrder() != null;
    }

    public void deserialize(ISpiritweb spiritweb) {
        this.spiritweb = spiritweb;
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        this.stormlightStored = compoundTag.m_128451_("stored_stormlight");
        this.idealsManager.deserialize(spiritweb);
        this.herald = compoundTag.m_128441_("herald") && compoundTag.m_128471_("herald");
    }

    public void serialize(ISpiritweb spiritweb) {
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        compoundTag.m_128405_("stored_stormlight", this.stormlightStored);
        this.idealsManager.serialize(spiritweb);
        if (this.herald) {
            compoundTag.m_128379_("herald", true);
        } else if (compoundTag.m_128441_("herald")) {
            compoundTag.m_128473_("herald");
        }
    }

    public void tickServer(ISpiritweb spiritweb) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack breastplate;
        ItemStack helmet;
        boolean surgebindingActiveTick;
        LivingEntity livingEntity = spiritweb.getLiving();
        boolean bl = surgebindingActiveTick = (livingEntity.f_19797_ + Manifestations.ManifestationTypes.SURGEBINDING.getID()) % 20 == 0;
        if (this.isOathed() && this.stormlightStored > 0 && surgebindingActiveTick) {
            if (livingEntity.m_21223_() < livingEntity.m_21233_()) {
                int stormlightHealingCostMultiplier = 20;
                if (this.adjustStormlight(-20, true)) {
                    SurgeProgression.heal(livingEntity, livingEntity.m_21223_() + 1.0f);
                }
            } else if (livingEntity.m_21231_().f_19281_) {
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19600_, (int)0));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19596_, (int)0));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19603_, (int)0));
                this.adjustStormlight(-30, true);
            } else if (livingEntity.m_5842_()) {
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19608_, (int)0));
                this.adjustStormlight(-10, true);
            } else {
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19598_, (int)0));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19596_, (int)0));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19603_, (int)0));
                this.adjustStormlight(-30, true);
            }
            int drainRate = (Integer)SurgebindingConfigs.SERVER.STORMLIGHT_DRAIN_RATE.get();
            this.adjustStormlight(-drainRate, true);
        }
        if (surgebindingActiveTick && Stream.of(helmet = livingEntity.m_6844_(EquipmentSlot.HEAD), breastplate = livingEntity.m_6844_(EquipmentSlot.CHEST), leggings = livingEntity.m_6844_(EquipmentSlot.LEGS), boots = livingEntity.m_6844_(EquipmentSlot.FEET)).allMatch(armorStack -> !armorStack.m_41619_() && armorStack.m_41720_() instanceof ArmorItem)) {
            for (ShardplateArmorMaterial material : ARMOR_MATERIALS) {
                if (!Stream.of(helmet, breastplate, leggings, boots).allMatch(armorStack -> ((ArmorItem)armorStack.m_41720_()).m_40401_() == material)) continue;
                int amplifier = material == ShardplateArmorMaterial.DEADPLATE ? 0 : 1;
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19596_, (int)amplifier));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19598_, (int)amplifier));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19600_, (int)amplifier));
                livingEntity.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19603_, (int)amplifier));
                --this.stormlightStored;
                break;
            }
        }
    }

    public void drainInvestiture(ISpiritweb data, double strength) {
        this.stormlightStored = (int)((float)this.stormlightStored * 0.1f);
    }

    private void requestGemStormlight(ItemStack item, int amountDrawn) {
        GemstoneItem gemstoneItem = (GemstoneItem)item.m_41720_();
        int availableSpace = this.maxPlayerStormlight - this.stormlightStored;
        if (availableSpace < amountDrawn) {
            amountDrawn = availableSpace;
        }
        if (gemstoneItem.getCharge(item) >= amountDrawn) {
            gemstoneItem.adjustCharge(item, -amountDrawn);
            this.stormlightStored += amountDrawn;
        } else {
            this.stormlightStored += gemstoneItem.getCharge(item);
            gemstoneItem.setCharge(item, 0);
        }
    }

    public void requestStormlight() {
        LivingEntity entity = this.spiritweb.getLiving();
        if (SurgebindingSpiritwebSubmodule.isInHighstorm(entity)) {
            this.stormlightStored = this.maxPlayerStormlight - this.stormlightStored >= this.drawSpeed ? (this.stormlightStored += this.drawSpeed) : (this.stormlightStored += this.maxPlayerStormlight - this.stormlightStored);
        } else if (entity instanceof Player) {
            GemstoneItem gemstoneItem;
            Player player = (Player)entity;
            ItemStack item = entity.m_21120_(InteractionHand.MAIN_HAND);
            Item item2 = item.m_41720_();
            if (item2 instanceof GemstoneItem && (gemstoneItem = (GemstoneItem)item2).getCharge(item) != 0) {
                this.requestGemStormlight(item, this.drawSpeed);
            } else {
                List<ItemStack> invItems = SurgebindingSpiritwebSubmodule.getGemItems(player);
                List<ItemStack> chargedGems = invItems.stream().filter(gem -> ((GemstoneItem)gem.m_41720_()).getCharge((ItemStack)gem) > 0).toList();
                int gemAmount = chargedGems.size();
                if (!chargedGems.isEmpty()) {
                    int requestAmount = this.drawSpeed / gemAmount;
                    for (ItemStack gem2 : chargedGems) {
                        this.requestGemStormlight(gem2, requestAmount);
                    }
                }
            }
        }
    }

    private void dispatchGemStormlight(ItemStack item, int amountDrawn) {
        GemstoneItem gemstoneItem = (GemstoneItem)item.m_41720_();
        int availableSpace = gemstoneItem.getMaxCharge(item) - gemstoneItem.getCharge(item);
        if (availableSpace < amountDrawn) {
            amountDrawn = availableSpace;
        }
        if (this.stormlightStored >= amountDrawn) {
            gemstoneItem.adjustCharge(item, amountDrawn);
            this.adjustStormlight(-amountDrawn, true);
        } else {
            gemstoneItem.adjustCharge(item, this.stormlightStored);
            this.stormlightStored = 0;
        }
    }

    public void dispatchStormlight() {
        LivingEntity entity = this.spiritweb.getLiving();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack handItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (handItem.m_41720_() instanceof GemstoneItem) {
                this.dispatchGemStormlight(handItem, this.drawSpeed);
            } else {
                List<ItemStack> invItems = SurgebindingSpiritwebSubmodule.getGemItems(player);
                List<ItemStack> unchargedGems = invItems.stream().filter(gem -> {
                    GemstoneItem gemstoneItem = (GemstoneItem)gem.m_41720_();
                    return gemstoneItem.getMaxCharge((ItemStack)gem) - gemstoneItem.getCharge((ItemStack)gem) > 0;
                }).toList();
                if (unchargedGems.isEmpty()) {
                    this.adjustStormlight(-this.drawSpeed, true);
                } else {
                    int dispatchAmount = this.drawSpeed / unchargedGems.size();
                    for (ItemStack gem2 : unchargedGems) {
                        this.dispatchGemStormlight(gem2, dispatchAmount);
                    }
                }
            }
        }
    }

    public static boolean isInHighstorm(LivingEntity entity) {
        return entity.m_9236_().m_46470_() && entity.m_9236_().m_46472_().equals(SurgebindingDimensions.ROSHAR_DIM_KEY) && entity.m_9236_().m_46758_(entity.m_20183_());
    }

    public static List<ItemStack> getGemItems(Player player) {
        if (player == null) {
            return Collections.emptyList();
        }
        CapWrapper acc = new CapWrapper((IItemHandler)new PlayerInvWrapper(player.m_150109_()));
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>(acc.m_6643_());
        for (int slot = 0; slot < acc.m_6643_(); ++slot) {
            ItemStack stackInSlot = acc.m_8020_(slot);
            if (stackInSlot.m_41619_() || !(stackInSlot.m_41720_() instanceof GemstoneItem)) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    public int getStormlight() {
        return this.stormlightStored;
    }

    public boolean adjustStormlight(int amountToAdjust, boolean doAdjust) {
        int stormlight = this.getStormlight();
        int newSLValue = stormlight + amountToAdjust;
        if (newSLValue >= 0) {
            if (doAdjust) {
                this.stormlightStored = Mth.m_14045_((int)newSLValue, (int)0, (int)this.maxPlayerStormlight);
            }
            return true;
        }
        return false;
    }

    public void setStormlight(int amount) {
        this.stormlightStored = Mth.m_14045_((int)amount, (int)0, (int)this.maxPlayerStormlight);
    }

    public void onChatMessageReceived(ServerChatEvent event) {
        this.idealsManager.onChatMessageReceived(event);
    }

    public void setHerald(boolean isHerald) {
        this.herald = isHerald;
    }
}

