/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.registries;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.registration.impl.ManifestationDeferredRegister;
import leaf.cosmere.common.registration.impl.ManifestationRegistryObject;
import leaf.cosmere.surgebinding.common.manifestation.SurgeAbrasion;
import leaf.cosmere.surgebinding.common.manifestation.SurgeAdhesion;
import leaf.cosmere.surgebinding.common.manifestation.SurgeCohesion;
import leaf.cosmere.surgebinding.common.manifestation.SurgeDivision;
import leaf.cosmere.surgebinding.common.manifestation.SurgeGravitation;
import leaf.cosmere.surgebinding.common.manifestation.SurgeIllumination;
import leaf.cosmere.surgebinding.common.manifestation.SurgeProgression;
import leaf.cosmere.surgebinding.common.manifestation.SurgeTension;
import leaf.cosmere.surgebinding.common.manifestation.SurgeTransformation;
import leaf.cosmere.surgebinding.common.manifestation.SurgeTransportation;
import leaf.cosmere.surgebinding.common.manifestation.SurgebindingManifestation;

public class SurgebindingManifestations {
    public static final ManifestationDeferredRegister MANIFESTATIONS = new ManifestationDeferredRegister("surgebinding");
    public static final Map<Roshar.Surges, ManifestationRegistryObject<Manifestation>> SURGEBINDING_POWERS = Arrays.stream(EnumUtils.SURGES).collect(Collectors.toMap(Function.identity(), surge -> MANIFESTATIONS.register(surge.getName(), () -> SurgebindingManifestations.makeSurgebindingManifestation(surge))));

    private static SurgebindingManifestation makeSurgebindingManifestation(Roshar.Surges surge) {
        return switch (surge) {
            default -> throw new IncompatibleClassChangeError();
            case Roshar.Surges.ADHESION -> new SurgeAdhesion(surge);
            case Roshar.Surges.GRAVITATION -> new SurgeGravitation(surge);
            case Roshar.Surges.DIVISION -> new SurgeDivision(surge);
            case Roshar.Surges.ABRASION -> new SurgeAbrasion(surge);
            case Roshar.Surges.PROGRESSION -> new SurgeProgression(surge);
            case Roshar.Surges.ILLUMINATION -> new SurgeIllumination(surge);
            case Roshar.Surges.TRANSFORMATION -> new SurgeTransformation(surge);
            case Roshar.Surges.TRANSPORTATION -> new SurgeTransportation(surge);
            case Roshar.Surges.COHESION -> new SurgeCohesion(surge);
            case Roshar.Surges.TENSION -> new SurgeTension(surge);
        };
    }
}

