/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IModModule;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Version;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.config.CosmereModConfig;
import leaf.cosmere.surgebinding.common.capabilities.SurgebindingSpiritwebSubmodule;
import leaf.cosmere.surgebinding.common.capabilities.world.IRoshar;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.network.SurgebindingPacketHandler;
import leaf.cosmere.surgebinding.common.registries.SurgebindingArgumentTypes;
import leaf.cosmere.surgebinding.common.registries.SurgebindingAttributes;
import leaf.cosmere.surgebinding.common.registries.SurgebindingBiomeModifiers;
import leaf.cosmere.surgebinding.common.registries.SurgebindingBiomes;
import leaf.cosmere.surgebinding.common.registries.SurgebindingBlocks;
import leaf.cosmere.surgebinding.common.registries.SurgebindingCreativeTabs;
import leaf.cosmere.surgebinding.common.registries.SurgebindingDimensions;
import leaf.cosmere.surgebinding.common.registries.SurgebindingEntityTypes;
import leaf.cosmere.surgebinding.common.registries.SurgebindingFeatures;
import leaf.cosmere.surgebinding.common.registries.SurgebindingItems;
import leaf.cosmere.surgebinding.common.registries.SurgebindingManifestations;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="surgebinding")
public class Surgebinding
implements IModModule {
    public static final String MODID = "surgebinding";
    public static Surgebinding instance;
    public final Version versionNumber;
    private final SurgebindingPacketHandler packetHandler;

    public Surgebinding() {
        instance = this;
        Cosmere.addModule((IModModule)instance);
        SurgebindingConfigs.registerConfigs(ModLoadingContext.get());
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::onConfigReload);
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onAddCaps);
        SurgebindingBlocks.BLOCKS.register(modBus);
        SurgebindingItems.ITEMS.register(modBus);
        SurgebindingEntityTypes.ENTITY_TYPES.register(modBus);
        SurgebindingAttributes.ATTRIBUTES.register(modBus);
        SurgebindingManifestations.MANIFESTATIONS.register(modBus);
        SurgebindingBiomes.BIOMES.register(modBus);
        SurgebindingBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modBus);
        SurgebindingFeatures.CONFIGURED_FEATURES.register(modBus);
        SurgebindingFeatures.PLACED_FEATURES.register(modBus);
        SurgebindingCreativeTabs.CREATIVE_TABS.register(modBus);
        SurgebindingArgumentTypes.ARGUMENT_TYPE_INFOS.register(modBus);
        SurgebindingDimensions.register();
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        this.packetHandler = new SurgebindingPacketHandler();
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public String getName() {
        return "Surgebinding";
    }

    public ISpiritwebSubmodule makeSubmodule() {
        return new SurgebindingSpiritwebSubmodule();
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public static SurgebindingPacketHandler packetHandler() {
        return Surgebinding.instance.packetHandler;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CosmereAPI.logger.info("Cosmere: Surgebinding module Version {} initializing...", (Object)this.versionNumber);
        event.enqueueWork(() -> {});
        this.packetHandler.initialize();
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }

    private void onAddCaps(RegisterCapabilitiesEvent capabilitiesEvent) {
        capabilitiesEvent.register(IRoshar.class);
    }
}

