/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class RadiantOrderArgumentType
implements ArgumentType<Roshar.RadiantOrder> {
    private static final Collection<String> EXAMPLES = Arrays.stream(Roshar.RadiantOrder.values()).map(Roshar.RadiantOrder::getName).toList();
    public static final DynamicCommandExceptionType INVALID_ORDER_EXCEPTION = new DynamicCommandExceptionType(order -> Component.m_237110_((String)"argument.surgebinding.order.invalid", (Object[])new Object[]{order}));

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static RadiantOrderArgumentType createArgument() {
        return new RadiantOrderArgumentType();
    }

    public Roshar.RadiantOrder parse(StringReader reader) throws CommandSyntaxException {
        String readerRead = reader.readUnquotedString().toUpperCase(Locale.ROOT);
        try {
            return Roshar.RadiantOrder.valueOf((String)readerRead);
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ORDER_EXCEPTION.create((Object)readerRead);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof SharedSuggestionProvider ? SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)RadiantOrderArgumentType.addSuggestions(builder)) : Suggestions.empty();
    }

    public static SuggestionsBuilder addSuggestions(SuggestionsBuilder builder) {
        for (Roshar.RadiantOrder order : EnumUtils.RADIANT_ORDERS) {
            builder.suggest(order.getName());
        }
        builder.buildFuture();
        return builder;
    }
}

