/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.surgebinding.common.items.ShardbladeItem;
import leaf.cosmere.surgebinding.common.registries.SurgebindingAttributes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;

public class HonorbladeItem
extends ShardbladeItem {
    public final Roshar.RadiantOrder radiantOrder;
    private Multimap<Attribute, AttributeModifier> attributeModifiers = null;
    protected static final UUID PRIMARY_HONORBLADE_SURGE_UUID = UUID.fromString("CB3F55D3-4865-4180-A497-9C13A33DB5CF");
    protected static final UUID SECONDARY_HONORBLADE_SURGE_UUID = UUID.fromString("FA233E1C-4180-4865-A497-BCCE9785ACA3");

    public HonorbladeItem(Roshar.RadiantOrder gemstone, Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
        this.radiantOrder = gemstone;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.attributeModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeedIn, AttributeModifier.Operation.ADDITION));
            builder.put((Object)SurgebindingAttributes.SURGEBINDING_ATTRIBUTES.get(this.radiantOrder.getFirstSurge()).getAttribute(), (Object)new AttributeModifier(PRIMARY_HONORBLADE_SURGE_UUID, "SurgeAttribute", 5.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)SurgebindingAttributes.SURGEBINDING_ATTRIBUTES.get(this.radiantOrder.getSecondSurge()).getAttribute(), (Object)new AttributeModifier(SECONDARY_HONORBLADE_SURGE_UUID, "SurgeAttribute", 5.0, AttributeModifier.Operation.ADDITION));
            this.attributeModifiers = builder.build();
        }
        return switch (equipmentSlot) {
            case EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND -> this.attributeModifiers;
            default -> super.getAttributeModifiers(equipmentSlot, stack);
        };
    }

    @Override
    public boolean canSummonDismiss(Player player) {
        return true;
    }
}

