/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.manifestation;

import java.util.HashMap;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.surgebinding.common.capabilities.SurgebindingSpiritwebSubmodule;
import leaf.cosmere.surgebinding.common.config.SurgebindingConfigs;
import leaf.cosmere.surgebinding.common.manifestation.SurgebindingManifestation;
import leaf.cosmere.surgebinding.common.registries.SurgebindingManifestations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class SurgeProgression
extends SurgebindingManifestation {
    private static final HashMap<Block, Block> progressionBlockMap = new HashMap();

    public SurgeProgression(Roshar.Surges surge) {
        super(surge);
    }

    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        AgeableMob ageableMob;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity eventTarget = (LivingEntity)entity;
            float eventTargetHealth = eventTarget.m_21223_();
            float eventTargetMaxHealth = eventTarget.m_21233_();
            int healthMissing = Mth.m_14143_((float)(eventTargetMaxHealth - eventTargetHealth));
            if (healthMissing > 0) {
                SpiritwebCapability.get((LivingEntity)event.getEntity()).ifPresent(iSpiritweb -> {
                    if (iSpiritweb.hasManifestation((Manifestation)SurgebindingManifestations.SURGEBINDING_POWERS.get(Roshar.Surges.PROGRESSION).get())) {
                        int stormlightHealingCostMultiplier;
                        SpiritwebCapability playerSpiritweb = (SpiritwebCapability)iSpiritweb;
                        SurgebindingSpiritwebSubmodule submodule = (SurgebindingSpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SURGEBINDING);
                        if (submodule.adjustStormlight(-(healthMissing * (stormlightHealingCostMultiplier = ((Integer)SurgebindingConfigs.SERVER.PROGRESSION_HEAL_COST.get()).intValue())), true)) {
                            SurgeProgression.heal(eventTarget, eventTargetMaxHealth);
                        } else {
                            int affordableHealth = submodule.getStormlight() / stormlightHealingCostMultiplier;
                            if (affordableHealth > 0 && submodule.adjustStormlight(-submodule.getStormlight(), true)) {
                                SurgeProgression.heal(eventTarget, eventTargetHealth + (float)affordableHealth);
                            }
                        }
                    }
                });
            }
        }
        if ((entity = event.getTarget()) instanceof AgeableMob && (ageableMob = (AgeableMob)entity).m_9236_() instanceof ServerLevel && ageableMob.m_6162_()) {
            SpiritwebCapability.get((LivingEntity)event.getEntity()).ifPresent(iSpiritweb -> {
                if (iSpiritweb.hasManifestation((Manifestation)SurgebindingManifestations.SURGEBINDING_POWERS.get(Roshar.Surges.PROGRESSION).get())) {
                    int stormlightAgeUpCostMultiplier;
                    int ageUpAmount = (int)Math.floor(-((double)ageableMob.m_146764_() / 20.0) * 0.1);
                    SpiritwebCapability playerSpiritweb = (SpiritwebCapability)iSpiritweb;
                    SurgebindingSpiritwebSubmodule submodule = (SurgebindingSpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SURGEBINDING);
                    if (submodule.adjustStormlight(-(stormlightAgeUpCostMultiplier = ((Integer)SurgebindingConfigs.SERVER.PROGRESSION_AGE_UP_COST.get()).intValue()), true)) {
                        SurgeProgression.ageUp(ageableMob, ageUpAmount);
                    } else {
                        int affordableAge = (int)((float)submodule.getStormlight() / (float)stormlightAgeUpCostMultiplier) * ageUpAmount;
                        if (affordableAge > 0 && submodule.adjustStormlight(-submodule.getStormlight(), true)) {
                            SurgeProgression.ageUp(ageableMob, affordableAge);
                        }
                    }
                }
            });
        }
    }

    public static void heal(LivingEntity livingEntity, float setHealthTo) {
        livingEntity.m_21153_(setHealthTo);
        for (int i = 0; i < 20; ++i) {
            double xSpeed = livingEntity.m_217043_().m_188583_() * 0.02;
            double ySpeed = livingEntity.m_217043_().m_188583_() * 0.02;
            double zSpeed = livingEntity.m_217043_().m_188583_() * 0.02;
            livingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, livingEntity.m_20165_(1.0) - xSpeed * 10.0, livingEntity.m_20187_() - ySpeed * 10.0, livingEntity.m_20262_(1.0) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void ageUp(AgeableMob ageableMob, int ageUpAmount) {
        ageableMob.m_146758_(ageUpAmount);
        for (int i = 0; i < 20; ++i) {
            double xSpeed = ageableMob.m_217043_().m_188583_() * 0.02;
            double ySpeed = ageableMob.m_217043_().m_188583_() * 0.02;
            double zSpeed = ageableMob.m_217043_().m_188583_() * 0.02;
            ageableMob.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, ageableMob.m_20165_(1.0) - xSpeed * 10.0, ageableMob.m_20187_() - ySpeed * 10.0, ageableMob.m_20262_(1.0) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        BlockPos blockPos = event.getHitVec().m_82425_();
        BlockState blockState = event.getLevel().m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            SpiritwebCapability.get((LivingEntity)event.getEntity()).ifPresent(iSpiritweb -> {
                int stormlightHealingCostMultiplier;
                SpiritwebCapability playerSpiritweb;
                SurgebindingSpiritwebSubmodule submodule;
                if (iSpiritweb.hasManifestation((Manifestation)SurgebindingManifestations.SURGEBINDING_POWERS.get(Roshar.Surges.PROGRESSION).get()) && (submodule = (SurgebindingSpiritwebSubmodule)(playerSpiritweb = (SpiritwebCapability)iSpiritweb).getSubmodule(Manifestations.ManifestationTypes.SURGEBINDING)).adjustStormlight(-(stormlightHealingCostMultiplier = ((Integer)SurgebindingConfigs.SERVER.PROGRESSION_BONEMEAL_COST.get()).intValue()), true)) {
                    Level patt6792$temp = event.getLevel();
                    if (patt6792$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt6792$temp;
                        bonemealableBlock.m_214148_(serverLevel, serverLevel.f_46441_, blockPos, blockState);
                    } else {
                        BoneMealItem.m_40638_((LevelAccessor)event.getLevel(), (BlockPos)blockPos, (int)0);
                    }
                }
            });
        } else {
            Block targetBlockType;
            if (progressionBlockMap.isEmpty()) {
                progressionBlockMap.put(Blocks.f_50493_, Blocks.f_50440_);
                progressionBlockMap.put(Blocks.f_50546_, Blocks.f_50493_);
                progressionBlockMap.put(Blocks.f_50652_, Blocks.f_50079_);
                progressionBlockMap.put(Blocks.f_50409_, Blocks.f_50647_);
                progressionBlockMap.put(Blocks.f_50157_, Blocks.f_50633_);
                progressionBlockMap.put(Blocks.f_50274_, Blocks.f_50275_);
            }
            if ((targetBlockType = (Block)progressionBlockMap.getOrDefault(blockState.m_60734_(), null)) != null) {
                SpiritwebCapability.get((LivingEntity)event.getEntity()).ifPresent(iSpiritweb -> {
                    int stormlightBonemealCostMultiplier;
                    SpiritwebCapability playerSpiritweb = (SpiritwebCapability)iSpiritweb;
                    SurgebindingSpiritwebSubmodule submodule = (SurgebindingSpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SURGEBINDING);
                    if (submodule.adjustStormlight(-(stormlightBonemealCostMultiplier = ((Integer)SurgebindingConfigs.SERVER.PROGRESSION_BONEMEAL_COST.get()).intValue()), true)) {
                        if (event.getLevel() instanceof ServerLevel) {
                            BlockState newState = targetBlockType.m_49966_();
                            for (Property prop : blockState.m_61147_()) {
                                if (!newState.m_61138_(prop)) continue;
                                newState = SurgeProgression.copyProperty(blockState, newState, prop);
                            }
                            event.getLevel().m_7731_(blockPos, newState, 0);
                        } else {
                            BoneMealItem.m_40638_((LevelAccessor)event.getLevel(), (BlockPos)blockPos, (int)0);
                        }
                    }
                });
            }
        }
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }
}

