/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.surgebinding.common.registries;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.common.registration.impl.BlockDeferredRegister;
import leaf.cosmere.common.registration.impl.BlockRegistryObject;
import leaf.cosmere.surgebinding.common.blocks.GemBlock;
import leaf.cosmere.surgebinding.common.blocks.LavisPolypBlock;
import leaf.cosmere.surgebinding.common.blocks.PrickletacBlock;
import leaf.cosmere.surgebinding.common.blocks.RockbudVariantBlock;
import leaf.cosmere.surgebinding.common.blocks.VinebudBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Rarity;

public class SurgebindingBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("surgebinding");
    public static final Map<Roshar.Gemstone, BlockRegistryObject<GemBlock, BlockItem>> GEM_BLOCKS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), gemstone -> BLOCKS.registerWithRarity(gemstone.getName() + "_block", () -> new GemBlock((Roshar.Gemstone)gemstone), Rarity.UNCOMMON)));
    public static final BlockRegistryObject<LavisPolypBlock, BlockItem> LAVIS_POLYP_BLOCK = BLOCKS.register("lavis_polyp", LavisPolypBlock::new);
    public static final BlockRegistryObject<PrickletacBlock, BlockItem> PRICKLETAC_BLOCK = BLOCKS.register("prickletac", PrickletacBlock::new);
    public static final BlockRegistryObject<RockbudVariantBlock, BlockItem> ROCKBUD_VARIANT_BLOCK = BLOCKS.register("rockbud_variant", RockbudVariantBlock::new);
    public static final BlockRegistryObject<VinebudBlock, BlockItem> VINEBUD_BLOCK = BLOCKS.register("vinebud", VinebudBlock::new);
    public static final ImmutableList<BlockRegistryObject<?, BlockItem>> PLANT_BLOCKS = ImmutableList.of(LAVIS_POLYP_BLOCK, PRICKLETAC_BLOCK, ROCKBUD_VARIANT_BLOCK, VINEBUD_BLOCK);
}

