/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.block.LinkTurtle;

import com.awesoft.cclink.libs.LuaConverter;
import com.awesoft.cclink.libs.RaycastingUtil;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleLinkAPI
implements ILuaAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TurtleLinkAPI.class);
    private final IComputerSystem computer;
    private final ITurtleAccess turtle;

    public TurtleLinkAPI(IComputerSystem computer, ITurtleAccess turtle) {
        this.computer = computer;
        this.turtle = turtle;
    }

    public String[] getNames() {
        return new String[]{"link_turtle"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycast(double reach) {
        return RaycastingUtil.raycast(reach, this.turtle, this.turtle.getDirection());
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycastUp(double reach) {
        return RaycastingUtil.raycast(reach, this.turtle, Direction.UP);
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycastDown(double reach) {
        return RaycastingUtil.raycast(reach, this.turtle, Direction.DOWN);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult list() throws LuaException {
        Container inventory = this.turtle.getInventory();
        if (inventory == null) {
            throw new LuaException("Turtle isn't present");
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            items.add(LuaConverter.stackToObjectWithSlot(stack, i));
        }
        return MethodResult.of(items);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getDirection() {
        return MethodResult.of((Object)this.turtle.getDirection().toString());
    }
}

