/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.datagen.recipes;

import com.awesoft.cclink.datagen.recipes.ModRecipes;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class LinkUpgradeRecipeType
extends ShapelessRecipe {
    private final ResourceLocation id;
    private final String upgrade;
    private final ItemStack result;

    public LinkUpgradeRecipeType(ResourceLocation pId, String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients, String upgrade) {
        super(pId, pGroup, pCategory, pResult, pIngredients);
        this.id = pId;
        this.upgrade = upgrade;
        this.result = pResult;
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = this.m_8043_(registryAccess).m_41777_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("ComputerId")) continue;
            CompoundTag tag = stack.m_41783_().m_6426_();
            tag.m_128359_("Upgrade", this.upgrade);
            result.m_41751_(tag);
            break;
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.LINK_UPGRADE.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<LinkUpgradeRecipeType> {
        public LinkUpgradeRecipeType fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe base = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_6729_(recipeId, json);
            JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            String upgradeId = GsonHelper.m_13906_((JsonObject)resultObj, (String)"upgrade");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultObj);
            return new LinkUpgradeRecipeType(recipeId, base.m_6076_(), base.m_245232_(), result, (NonNullList<Ingredient>)base.m_7527_(), upgradeId);
        }

        public LinkUpgradeRecipeType fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            String upgradeId = buffer.m_130277_();
            return new LinkUpgradeRecipeType(id, group, category, result, (NonNullList<Ingredient>)ingredients, upgradeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, LinkUpgradeRecipeType recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.m_130070_(recipe.upgrade);
        }
    }
}

