/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.hudoverlay;

import com.awesoft.cclink.hudoverlay.ItemElement;
import com.awesoft.cclink.hudoverlay.PlayerGuiDimensions;
import com.awesoft.cclink.hudoverlay.RectangleElement;
import com.awesoft.cclink.hudoverlay.RightboundTextElement;
import com.awesoft.cclink.hudoverlay.TextElement;
import com.awesoft.cclink.libs.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="cclink", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HUDOverlay {
    private static final Map<UUID, Map<String, RectangleElement>> playerRectangleElements = new HashMap<UUID, Map<String, RectangleElement>>();
    private static final Map<UUID, Map<String, TextElement>> playerTextElements = new HashMap<UUID, Map<String, TextElement>>();
    private static final Map<UUID, Map<String, RightboundTextElement>> playerRightboundTextElements = new HashMap<UUID, Map<String, RightboundTextElement>>();
    private static final Map<UUID, Map<String, ItemElement>> playerItemElements = new HashMap<UUID, Map<String, ItemElement>>();
    private static final Map<UUID, PlayerGuiDimensions> playerGuiDimensions = new HashMap<UUID, PlayerGuiDimensions>();

    private static ServerPlayer getServerPlayer(UUID playerUUID) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerUUID);
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            HUDOverlay.renderHUD(event.getGuiGraphics(), player.m_20148_());
        }
    }

    private static void renderHUD(GuiGraphics guiGraphics, UUID playerUUID) {
        Map<String, ItemElement> map;
        Map<String, RightboundTextElement> map2;
        Map<String, TextElement> textElements;
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = guiGraphics.m_280168_();
        Map<String, RectangleElement> rectangleElements = playerRectangleElements.get(playerUUID);
        if (rectangleElements != null) {
            for (RectangleElement rectangleElement : rectangleElements.values()) {
                poseStack.m_85836_();
                guiGraphics.m_280509_(rectangleElement.getX1(), rectangleElement.getY1(), rectangleElement.getX2(), rectangleElement.getY2(), rectangleElement.getColor());
                poseStack.m_85849_();
            }
        }
        if ((textElements = playerTextElements.get(playerUUID)) != null) {
            for (TextElement textElement : textElements.values()) {
                poseStack.m_85836_();
                poseStack.m_85841_(textElement.getScale(), textElement.getScale(), 1.0f);
                float scaledX = (float)textElement.getX() / textElement.getScale();
                float scaledY = (float)textElement.getY() / textElement.getScale();
                guiGraphics.m_280056_(mc.f_91062_, textElement.getText(), (int)scaledX, (int)scaledY, textElement.getColor(), false);
                poseStack.m_85849_();
            }
        }
        if ((map2 = playerRightboundTextElements.get(playerUUID)) != null) {
            for (RightboundTextElement element : map2.values()) {
                poseStack.m_85836_();
                poseStack.m_85841_(element.getScale(), element.getScale(), 1.0f);
                float scaledX = (float)(element.getX() - mc.f_91062_.m_92895_(element.getText())) / element.getScale();
                float scaledY = (float)element.getY() / element.getScale();
                guiGraphics.m_280056_(mc.f_91062_, element.getText(), (int)scaledX, (int)scaledY, element.getColor(), false);
                poseStack.m_85849_();
            }
        }
        if ((map = playerItemElements.get(playerUUID)) != null) {
            for (ItemElement element : map.values()) {
                guiGraphics.m_280203_(element.getItemStack(), element.getX(), element.getY());
            }
        }
        int guiWidth = guiGraphics.m_280182_();
        int guiHeight = guiGraphics.m_280206_();
        playerGuiDimensions.put(playerUUID, new PlayerGuiDimensions(guiWidth, guiHeight));
    }

    public static void addOrUpdateRightboundTextElement(UUID playerUUID, String key, String text, int x, int y, int color, float scale) {
        playerRightboundTextElements.computeIfAbsent(playerUUID, k -> new HashMap()).put(key, new RightboundTextElement(text, x, y, color, scale));
    }

    public static void removeRightboundTextElement(UUID playerUUID, String key) {
        Map<String, RightboundTextElement> rightboundTextElements = playerRightboundTextElements.get(playerUUID);
        if (rightboundTextElements != null) {
            rightboundTextElements.remove(key);
            if (rightboundTextElements.isEmpty()) {
                playerRightboundTextElements.remove(playerUUID);
            }
        }
    }

    public static void clearRightboundTextElementsForPlayer(UUID playerUUID) {
        playerRightboundTextElements.remove(playerUUID);
    }

    public static void addOrUpdateItemElement(UUID playerUUID, String key, String itemName, int x, int y) {
        ItemStack itemStack = HUDOverlay.createItemStackFromString(itemName);
        if (itemStack != null) {
            playerItemElements.computeIfAbsent(playerUUID, k -> new HashMap()).put(key, new ItemElement(itemStack, x, y));
        }
    }

    private static ItemStack createItemStackFromString(String itemName) {
        ResourceLocation itemId = new ResourceLocation(itemName);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return new ItemStack((ItemLike)Blocks.f_50016_);
    }

    public static void removeItemElement(UUID playerUUID, String key) {
        Map<String, ItemElement> itemElements = playerItemElements.get(playerUUID);
        if (itemElements != null) {
            itemElements.remove(key);
        }
    }

    public static void clearItemElementsForPlayer(UUID playerUUID) {
        playerItemElements.remove(playerUUID);
    }

    public static void addOrUpdateRectangleElement(UUID playerUUID, String key, int x1, int y1, int x2, int y2, int rgbColor, int transparency) {
        int color = ColorUtil.toArgb(rgbColor, transparency);
        playerRectangleElements.computeIfAbsent(playerUUID, k -> new HashMap()).put(key, new RectangleElement(x1, y1, x2, y2, color));
    }

    public static void removeRectangleElement(UUID playerUUID, String key) {
        Map<String, RectangleElement> rectangleElements = playerRectangleElements.get(playerUUID);
        if (rectangleElements != null) {
            rectangleElements.remove(key);
            if (rectangleElements.isEmpty()) {
                playerRectangleElements.remove(playerUUID);
            }
        }
    }

    public static void clearRectangleElementsForPlayer(UUID playerUUID) {
        playerRectangleElements.remove(playerUUID);
    }

    public static void addOrUpdateTextElement(UUID playerUUID, String key, String text, int x, int y, int color, float scale) {
        playerTextElements.computeIfAbsent(playerUUID, k -> new HashMap()).put(key, new TextElement(text, x, y, color, scale));
    }

    public static void removeTextElement(UUID playerUUID, String key) {
        Map<String, TextElement> textElements = playerTextElements.get(playerUUID);
        if (textElements != null) {
            textElements.remove(key);
            if (textElements.isEmpty()) {
                playerTextElements.remove(playerUUID);
            }
        }
    }

    public static void clearTextElementsForPlayer(UUID playerUUID) {
        playerTextElements.remove(playerUUID);
    }
}

