/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.item.EntityLink;

import com.awesoft.cclink.item.EntityLink.EntityLinkComputerItem;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface EntityLinkHolder {
    public ServerLevel level();

    public Vec3 pos();

    public BlockPos blockPos();

    public boolean isValid(ServerComputer var1);

    public void setChanged();

    default public boolean isTerminalAlwaysVisible() {
        return false;
    }

    public record LecternHolder(CustomLecternBlockEntity lectern) implements EntityLinkHolder
    {
        @Override
        public ServerLevel level() {
            return (ServerLevel)this.lectern.m_58904_();
        }

        @Override
        public Vec3 pos() {
            return Vec3.m_82512_((Vec3i)this.lectern.m_58899_());
        }

        @Override
        public BlockPos blockPos() {
            return this.lectern.m_58899_();
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return !this.lectern().m_58901_() && EntityLinkComputerItem.isServerComputer(computer, this.lectern.getItem());
        }

        @Override
        public void setChanged() {
            BlockEntityHelpers.updateBlock((BlockEntity)this.lectern());
        }

        @Override
        public boolean isTerminalAlwaysVisible() {
            return true;
        }
    }

    public static final class ItemEntityHolder
    extends Record
    implements EntityHolder {
        private final ItemEntity entity;

        public ItemEntityHolder(ItemEntity entity) {
            this.entity = entity;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().m_6084_() && EntityLinkComputerItem.isServerComputer(computer, this.entity().m_32055_());
        }

        @Override
        public void setChanged() {
            this.entity.m_32045_(this.entity.m_32055_().m_41777_());
        }

        public ItemEntity entity() {
            return this.entity;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this, o);
        }
    }

    public static final class LivingEntityHolder
    extends Record
    implements EntityHolder {
        private final LivingEntity entity;
        private final ServerPlayer player;
        private final int slot;

        public LivingEntityHolder(LivingEntity entity, ServerPlayer player, int slot) {
            this.entity = entity;
            this.player = player;
            this.slot = slot;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().m_6084_();
        }

        @Override
        public void setChanged() {
            this.player.m_150109_().m_6596_();
        }

        public LivingEntity entity() {
            return this.entity;
        }

        public int slot() {
            return this.slot;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LivingEntityHolder.class, "entity;player;slot", "entity", "player", "slot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LivingEntityHolder.class, "entity;player;slot", "entity", "player", "slot"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LivingEntityHolder.class, "entity;player;slot", "entity", "player", "slot"}, this, o);
        }

        public ServerPlayer player() {
            return this.player;
        }
    }

    public static final class PlayerHolder
    extends Record
    implements EntityHolder {
        private final ServerPlayer entity;
        private final int slot;

        public PlayerHolder(ServerPlayer entity, int slot) {
            this.entity = entity;
            this.slot = slot;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().m_6084_() && EntityLinkComputerItem.isServerComputer(computer, this.entity().m_150109_().m_8020_(this.slot()));
        }

        @Override
        public void setChanged() {
            this.entity.m_150109_().m_6596_();
        }

        public ServerPlayer entity() {
            return this.entity;
        }

        public int slot() {
            return this.slot;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this, o);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface EntityHolder
    extends EntityLinkHolder {
        public Entity entity();

        @Override
        default public ServerLevel level() {
            return (ServerLevel)this.entity().m_9236_();
        }

        @Override
        default public Vec3 pos() {
            return this.entity().m_146892_();
        }

        @Override
        default public BlockPos blockPos() {
            return this.entity().m_20183_();
        }
    }
}

