/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.item.LinkCore.Integrated;

import com.awesoft.cclink.Registration.ItemRegistry;
import com.awesoft.cclink.gui.integrated.IntegratedLinkMenu;
import com.awesoft.cclink.item.LinkCore.Integrated.IntegratedLinkBrain;
import com.awesoft.cclink.item.LinkCore.Integrated.IntegratedLinkHolder;
import com.awesoft.cclink.item.LinkCore.Integrated.IntegratedLinkServerComputer;
import com.awesoft.cclink.item.LinkCore.Integrated.ItemInvIntegratedLinkProvider;
import com.awesoft.cclink.libs.ItemHandlerContainer;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.container.SingleContainerData;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class IntegratedLinkCoreComputerItem
extends Item
implements IComputerItem,
IMedia,
IColouredItem,
ICurioItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_ON = "On";
    private static final String NBT_INSTANCE = "InstanceId";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public IntegratedLinkCoreComputerItem(Item.Properties settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemInvIntegratedLinkProvider(stack, 7);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        CompoundTag finalTag = tag;
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
            if (cap instanceof ItemStackHandler) {
                ItemStackHandler invProvider = (ItemStackHandler)cap;
                finalTag.m_128365_("Inventory", (Tag)invProvider.serializeNBT());
            }
        });
        return finalTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.m_128441_("Inventory")) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
                if (cap instanceof ItemStackHandler) {
                    ItemStackHandler handler = (ItemStackHandler)cap;
                    handler.deserializeNBT(nbt.m_128469_("Inventory"));
                }
            });
        }
    }

    public ItemStack create(int id, @Nullable String label, int colour, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        ItemStack result = new ItemStack((ItemLike)this);
        if (id >= 0) {
            result.m_41784_().m_128405_("ComputerId", id);
        }
        if (label != null) {
            result.m_41714_((Component)Component.m_237113_((String)label));
        }
        if (upgrade != null) {
            result.m_41784_().m_128359_(NBT_UPGRADE, ((IPocketUpgrade)upgrade.upgrade()).getUpgradeID().toString());
            if (!upgrade.data().m_128456_()) {
                result.m_41784_().m_128365_(NBT_UPGRADE_INFO, (Tag)upgrade.data().m_6426_());
            }
        }
        if (colour != -1) {
            result.m_41784_().m_128405_("Color", colour);
        }
        return result;
    }

    public void tick(ItemStack stack, IntegratedLinkHolder holder, boolean passive) {
        IntegratedLinkBrain brain;
        if (passive) {
            IntegratedLinkServerComputer computer = IntegratedLinkCoreComputerItem.getServerComputer(holder.level().m_7654_(), stack);
            if (computer == null) {
                return;
            }
            brain = computer.getBrain();
        } else {
            brain = this.getOrCreateBrain(holder.level(), holder, stack);
            brain.computer().keepAlive();
        }
        UpgradeData<IPocketUpgrade> upgrade = brain.getUpgrade();
        if (upgrade != null) {
            ((IPocketUpgrade)upgrade.upgrade()).update((IPocketAccess)brain, brain.computer().getPeripheral(ComputerSide.BACK));
        }
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(ItemStack stack, IntegratedLinkBrain brain) {
        boolean on;
        String label;
        boolean changed = brain.updateItem(stack);
        IntegratedLinkServerComputer computer = brain.computer();
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            IntegratedLinkCoreComputerItem.setComputerID(stack, id);
        }
        if (!Objects.equals(label = computer.getLabel(), this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != IntegratedLinkCoreComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.m_41784_().m_128379_(NBT_ON, on);
        }
        return changed;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int compartmentSlot, boolean selected) {
        if (!world.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (compartmentSlot <= 0) {
                this.tick(stack, new IntegratedLinkHolder.PlayerCuriosHolder(player), false);
            } else {
                int slot = InventoryUtil.getInventorySlotFromCompartment((Player)player, (int)compartmentSlot, (ItemStack)stack);
                if (slot >= 0) {
                    this.tick(stack, new IntegratedLinkHolder.PlayerHolder(player, slot), false);
                }
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        if (!level.f_46443_ && level.m_7654_() != null) {
            this.tick(stack, new IntegratedLinkHolder.ItemEntityHolder(entity), true);
            return false;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return CustomLecternBlock.defaultUseItemOn((UseOnContext)context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (!world.f_46443_) {
            if (helmet.m_41720_() == ItemRegistry.LINK_INTERFACE.get()) {
                IntegratedLinkHolder.PlayerHolder holder = new IntegratedLinkHolder.PlayerHolder((ServerPlayer)player, InventoryUtil.getHandSlot((Player)player, (InteractionHand)hand));
                IntegratedLinkBrain brain = this.getOrCreateBrain((ServerLevel)world, holder, stack);
                IntegratedLinkServerComputer computer = brain.computer();
                computer.turnOn();
                boolean stop = false;
                IPocketUpgrade upgrade = IntegratedLinkCoreComputerItem.getUpgrade(stack);
                if (upgrade != null) {
                    stop = upgrade.onRightClick(world, (IPocketAccess)brain, computer.getPeripheral(ComputerSide.BACK));
                    this.updateItem(stack, brain);
                }
                if (!stop) {
                    PlatformHelper.get().openMenu(player, player.m_21120_(hand).m_41786_(), (id, inventory, entity) -> new IntegratedLinkMenu(id, p -> true, ComputerFamily.ADVANCED, computer, null, player.m_150109_(), new ItemHandlerContainer((IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)), (net.minecraft.world.inventory.ContainerData)((SingleContainerData)brain::getSelectedSlot)), (ContainerData)new ComputerContainerData((ServerComputer)computer, ItemStack.f_41583_));
                }
            } else {
                CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ItemRegistry.LINK_INTERFACE.get()).ifPresent(slotResult -> {
                    IntegratedLinkHolder.PlayerHolder holder = new IntegratedLinkHolder.PlayerHolder((ServerPlayer)player, InventoryUtil.getHandSlot((Player)player, (InteractionHand)hand));
                    IntegratedLinkBrain brain = this.getOrCreateBrain((ServerLevel)world, holder, stack);
                    IntegratedLinkServerComputer computer = brain.computer();
                    computer.turnOn();
                    boolean stop = false;
                    IPocketUpgrade upgrade = IntegratedLinkCoreComputerItem.getUpgrade(stack);
                    if (upgrade != null) {
                        stop = upgrade.onRightClick(world, (IPocketAccess)brain, computer.getPeripheral(ComputerSide.BACK));
                        this.updateItem(stack, brain);
                    }
                    if (!stop) {
                        PlatformHelper.get().openMenu(player, player.m_21120_(hand).m_41786_(), (id, inventory, entity) -> new IntegratedLinkMenu(id, p -> true, ComputerFamily.ADVANCED, computer, null, player.m_150109_(), new ItemHandlerContainer((IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)), (net.minecraft.world.inventory.ContainerData)((SingleContainerData)brain::getSelectedSlot)), (ContainerData)new ComputerContainerData((ServerComputer)computer, ItemStack.f_41583_));
                    }
                });
            }
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)world.f_46443_), (Object)stack);
    }

    public void open(Player player, ItemStack stack, IntegratedLinkHolder holder, boolean isTypingOnly) {
        IntegratedLinkBrain brain = this.getOrCreateBrain(holder.level(), holder, stack);
        IntegratedLinkServerComputer computer = brain.computer();
        computer.turnOn();
        IntegratedLinkCoreComputerItem.openImpl(player, stack, holder, isTypingOnly, computer);
    }

    private static void openImpl(Player player, ItemStack stack, IntegratedLinkHolder holder, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.m_41786_(), (id, inventory, entity) -> new ComputerMenuWithoutInventory(isTypingOnly ? (MenuType)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get() : (MenuType)ModRegistry.Menus.COMPUTER.get(), id, inventory, p -> holder.isValid(computer), computer), (ContainerData)new ComputerContainerData(computer, stack));
    }

    public Component m_7626_(ItemStack stack) {
        String baseString = this.m_5671_(stack);
        IPocketUpgrade upgrade = IntegratedLinkCoreComputerItem.getUpgrade(stack);
        return upgrade != null ? Component.m_237110_((String)(baseString + ".upgraded"), (Object[])new Object[]{Component.m_237115_((String)upgrade.getUnlocalisedAdjective())}) : super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int id;
        if ((flag.m_7050_() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((Component)Component.m_237110_((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        IPocketUpgrade upgrade = IntegratedLinkCoreComputerItem.getUpgrade(stack);
        if (upgrade != null && (mod = PocketUpgrades.instance().getOwner((UpgradeBase)upgrade)) != null && !mod.equals("cclink")) {
            return mod;
        }
        return "cclink";
    }

    private IntegratedLinkBrain getOrCreateBrain(ServerLevel level, IntegratedLinkHolder holder, ItemStack stack) {
        ServerComputerRegistry registry = ServerContext.get((MinecraftServer)level.m_7654_()).registry();
        IntegratedLinkServerComputer computer = IntegratedLinkCoreComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            IntegratedLinkBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = this.getComputerID(stack);
        if (computerID < 0) {
            computerID = ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)level.m_7654_(), (String)"computer");
            IntegratedLinkCoreComputerItem.setComputerID(stack, computerID);
        }
        IntegratedLinkBrain brain = new IntegratedLinkBrain(holder, IntegratedLinkCoreComputerItem.getUpgradeWithData(stack), ServerComputer.properties((int)this.getComputerID(stack), (ComputerFamily)this.getFamily()).label(this.getLabel(stack)));
        IntegratedLinkServerComputer computerSigma = brain.computer();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(NBT_SESSION, registry.getSessionID());
        tag.m_128362_(NBT_INSTANCE, computerSigma.register());
        if (IntegratedLinkCoreComputerItem.isMarkedOn(stack)) {
            computerSigma.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, ItemStack stack) {
        return stack.m_41720_() instanceof IntegratedLinkCoreComputerItem && IntegratedLinkCoreComputerItem.getServerComputer(computer.getLevel().m_7654_(), stack) == computer;
    }

    @Nullable
    public static IntegratedLinkServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return (IntegratedLinkServerComputer)registry.get(IntegratedLinkCoreComputerItem.getSessionID(stack), IntegratedLinkCoreComputerItem.getInstanceID(stack));
    }

    @Nullable
    public static IntegratedLinkServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return IntegratedLinkCoreComputerItem.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        IntegratedLinkServerComputer computer;
        MinecraftServer server;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (server = level.m_7654_()) != null && (computer = IntegratedLinkCoreComputerItem.getServerComputer(server, stack)) != null) {
            computer.getBrain().setUpgrade(IntegratedLinkCoreComputerItem.getUpgradeWithData(stack));
        }
    }

    private static void setComputerID(ItemStack stack, int computerID) {
        stack.m_41784_().m_128405_("ComputerId", computerID);
    }

    @Nullable
    public String getLabel(ItemStack stack) {
        return super.getLabel(stack);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public ItemStack changeItem(ItemStack stack, Item newItem) {
        ItemStack var10000;
        if (newItem instanceof IntegratedLinkCoreComputerItem) {
            IntegratedLinkCoreComputerItem pocket = (IntegratedLinkCoreComputerItem)newItem;
            var10000 = pocket.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), IntegratedLinkCoreComputerItem.getUpgradeWithData(stack));
        } else {
            var10000 = ItemStack.f_41583_;
        }
        return var10000;
    }

    public boolean setLabel(ItemStack stack, @Nullable String label) {
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Nullable
    public Mount createDataMount(ItemStack stack, ServerLevel level) {
        int id = this.getComputerID(stack);
        return id >= 0 ? ComputerCraftAPI.createSaveDirMount((MinecraftServer)level.m_7654_(), (String)("computer/" + id), (long)Config.computerSpaceLimit) : null;
    }

    @Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_(NBT_INSTANCE) ? nbt.m_128342_(NBT_INSTANCE) : null;
    }

    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_SESSION) ? nbt.m_128451_(NBT_SESSION) : -1;
    }

    private static boolean isMarkedOn(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_(NBT_ON);
    }

    @Nullable
    public static IPocketUpgrade getUpgrade(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        return compound != null && compound.m_128441_(NBT_UPGRADE) ? (IPocketUpgrade)PocketUpgrades.instance().get(compound.m_128461_(NBT_UPGRADE)) : null;
    }

    @Nullable
    public static UpgradeData<IPocketUpgrade> getUpgradeWithData(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128441_(NBT_UPGRADE)) {
            IPocketUpgrade upgrade = (IPocketUpgrade)PocketUpgrades.instance().get(compound.m_128461_(NBT_UPGRADE));
            return upgrade == null ? null : UpgradeData.of((UpgradeBase)upgrade, (CompoundTag)NBTUtil.getCompoundOrEmpty((CompoundTag)compound, (String)NBT_UPGRADE_INFO));
        }
        return null;
    }

    public static void setUpgrade(ItemStack stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        CompoundTag compound = stack.m_41784_();
        if (upgrade == null) {
            compound.m_128473_(NBT_UPGRADE);
            compound.m_128473_(NBT_UPGRADE_INFO);
        } else {
            compound.m_128359_(NBT_UPGRADE, ((IPocketUpgrade)upgrade.upgrade()).getUpgradeID().toString());
            compound.m_128365_(NBT_UPGRADE_INFO, (Tag)upgrade.data().m_6426_());
        }
    }

    public static CompoundTag getUpgradeInfo(ItemStack stack) {
        return stack.m_41698_(NBT_UPGRADE_INFO);
    }
}

